package dressing.ui.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.ui.internal.actions.ClearWorkingSetAction;
import org.osgi.service.event.EventHandler;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.DesignException;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import dressing.ui.util.OpenWizardDialog;

public class RestoreProjectWizard extends Wizard {

	@Inject
	IEventBroker eventBroker;
	//0 for create 1 for open 
	private RestoreProjectPage openPage;
	SuperCadProject project;

	public RestoreProjectWizard() {
		
		setWindowTitle("Restaurer un projet");
		
		OpenWizardDialog container=(OpenWizardDialog) getContainer();
//		if(container!=null) {
//			((OpenWizardDialog) container).getButton(IDialogConstants.FINISH_ID).setText("Terminer");
//			((OpenWizardDialog) container).getButton(IDialogConstants.CANCEL_ID).setText("Annuler");
//		}
	}
	
	@Override
	public boolean performFinish() {
		SuperCadProject currentProject = ProjectManager.getManager().getCurrentProject();
		File f = openPage.getBackupFile();
		String projectName = f.getName();
		int indexextension = projectName.lastIndexOf('_');
		if (indexextension > 0) {
			projectName = projectName.substring(0, indexextension);
		}

		String path = currentProject.getProjectDirectory();
		File f1 = new File(path);
		if(f1.exists())
		{
			IOUtilities.deleteFolder(f1);
		}
		String DestfilePath = WorkspaceConfiguration.getProjectsPath() ;
		IOUtilities.UnzipFile(f.getAbsolutePath(), DestfilePath);
		System.err.println("exist "+f1.exists());
			
		String rootDir= WorkspaceConfiguration.getProjectsPath()+ File.separator +projectName;
		try {
			SuperCadProject project=ProjectManager.getManager().readProjectfromDisk(rootDir);
			if(project!=null) {
				project.setProjectDirectory(path);
				ProjectManager.getManager().addProject(project);	
				ProjectManager.getManager().setCurrentProject(project, true);
				project.setProjectDirectory(rootDir);
				ProjectManager.getManager().getProjects().remove(currentProject);

			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return true;
	}
	
	@Override
	public void addPages() {
		this.project = ProjectManager.getManager().getCurrentProject();
		openPage = new RestoreProjectPage(this.project);
		addPage(openPage);
	}
	
	@Override
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
	
}
