package dressing.ui.charniere;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.BlocTirroirCreator;
import dressing.controller.CharniereCreator;
import dressing.controller.CuisineCreator;
import dressing.model.Charniere;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Project3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;

public class CharniereWizard extends Wizard {
	CharniereWizardPage charnierePage;
	Space3D space;
	CharniereCreator creator=new CharniereCreator();
	public CharniereWizard() {
		setWindowTitle("ajouter des charnieres");
	}

	@Override
	public void addPages() {
		 charnierePage=new CharniereWizardPage("welcome Page", creator);
		this.addPage(charnierePage);
	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				this.creator.create();
				charnierePage.clearlistners();
				for(Charniere ch: creator.getListCharniere()) {
					ch.getParentdesign().addElement(ch);
					ch.getMother().addBaby(ch);
					ch.createUsinage();
				}
				
				
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
				for(Charniere ch: creator.getListCharniere()) {
					try {
						ch.getParentdesign().deletechild(ch);
						ch.getMother().removeBaby(ch);
					} catch (DesignException | GeometricEngineException e1) {
						e1.printStackTrace();
					}
				}
					return false;
			}

					
			return true;
	}
	
	public void setSpace3d(Space3D sapce) {
		this.space = sapce;	
		this.creator.setSpace(sapce);
	}
	

}
