package dressing.model;

import dressing.model.usinage.Trou;

public class Cylindre extends Plan3D{

	Point3D start;
	Point3D end ;	
	double raduis = 0;
	double diameter = 0;

	public Cylindre(Point3D start, Point3D end, double raduis) {
		super();
		this.start = start;
		this.end = end;
		this.raduis = raduis;
		this.diameter= raduis*2;
		this.createIntervals();
	}

	public Cylindre(Trou tr) {
		this.start = new Point3D(tr.getXPosABS(),tr.getYPosABS(),tr.getZPosABS());
		this.end=tr.getEndPoint();
		this.raduis=tr.getDiameter()/2;
		this.diameter=tr.getDiameter();
		createIntervals();
	}


	public Cylindre() {
		super();
	}

	private void createIntervals() {
		if(this.start.getX()!=this.end.getX()) {
			this.xinter=new Intervale(Math.min(this.start.getX(), this.end.getX()), true, Math.max(this.start.getX(), this.end.getX()), true);
			this.yinter=new Intervale(this.start.getY()-this.raduis,true,this.start.getY()+this.raduis,true);
			this.zinter=new Intervale(this.start.getZ()-this.raduis,true,this.start.getZ()+this.raduis,true);
		}else if(this.start.getY()!=this.end.getY()) {
			this.yinter=new Intervale(Math.min(this.start.getY(), this.end.getY()), true, Math.max(this.start.getY(), this.end.getY()), true);
			this.xinter=new Intervale(this.start.getX()-this.raduis,true,this.start.getX()+this.raduis,true);
			this.zinter=new Intervale(this.start.getZ()-this.raduis,true,this.start.getZ()+this.raduis,true);
		}
		else if(this.start.getZ()!=this.end.getZ()) {
			this.zinter=new Intervale(Math.min(this.start.getZ(), this.end.getZ()), true, Math.max(this.start.getZ(), this.end.getZ()), true);
			this.xinter=new Intervale(this.start.getX()-this.raduis,true,this.start.getX()+this.raduis,true);
			this.yinter=new Intervale(this.start.getY()-this.raduis,true,this.start.getY()+this.raduis,true);
		}
		
	}
	
}
