package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Space3D;
import dressing.ui.tiroire.TiroireWizard;

public class AddTiroirsWizardHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){

		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
	
			Space3D space =(Space3D)o;
			TiroireWizard tiroirwizrad = ContextInjectionFactory.make(TiroireWizard.class,eclipsecontext);
			tiroirwizrad.setSpace3d(space);
			WizardDialog dialog = new WizardDialog(shell, tiroirwizrad);
			dialog.open();		
			
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof Space3D)
		{
			return true;
		}	
		return false;
	}
}
