package gdxapp.object3d;

import java.util.ArrayList;
import java.util.UUID;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import dressing.model.types.PoigneePosition;
import dressing.model.types.PoigneeType;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.fabs3d.Planche;
import gdxapp.shaders.PbrMaterial;

public class DesignModelFactory {

	private Model golaModel;
	private ModelBuilder modelBuilder;
	private static DesignModelFactory factory;

	private DesignModelFactory() {
		modelBuilder = new ModelBuilder();
	}

	public Model createModelFromVertices(KitchenElement object) {
		int materialCounter = 0;
		if (object.getDesignObject() == null)
			return null;
		DesignObject3D design = object.getDesignObject();
		Space3D caisson = (Space3D) design;
		ArrayList<Planche> planches = new ArrayList<Planche>();
		for (DesignObject3D designX : caisson.getListPieces()) {
			if (designX instanceof Piece2D)
				planches.add(new Planche((Piece2D) designX, object));
		}
		String caissonType = object.getDesignObject().getDesignCaissonType();
		if (modelBuilder == null)
			modelBuilder = new ModelBuilder();

		boolean isSansPoignee = false;
		try {
			isSansPoignee = design.getPoigneeType().equals(PoigneeType.SANS_POIGNEE);
		} catch (Exception e) {
			e.printStackTrace();
		}
		PoigneePosition poigneePosition = design.getPoigneePosition();
		Orientation poigneeOrientation = design.getPoigneeOrientation();

		int counter = 0;
		modelBuilder.begin();
		PbrMaterial material;
		for (Planche planche : planches) {
			Node nodeX = modelBuilder.node();
			nodeX.id = "node_" + counter;
			planche.setVertices();
			material = planche.getMaterial();
			if (!material.isReady()) {
				material.prepare();
			}
			if (planche.getPiece2D().getMaterialType().isIsColor())
				material.remove(TextureAttribute.Diffuse);
			material.id = "mtl" + ++materialCounter;
			if (planche.getPiece2D() == null) {
				PolygonBuilder.createPolygoneNode(modelBuilder, "planche" + ++counter, planche.getLocalVertices(),
						new ArrayList<Vector2>(), material, planche.getTransform().cpy().inv(),
						new float[] { planche.getThickness() / 2, -planche.getThickness() / 2 });
			} else {
				PolygonBuilder.createPiece3D(modelBuilder, planche);
			}
			
		}
		if (isSansPoignee) {
			//createGolaModel(handle.getMaterial());
//			var usinages = design.getUsinages(design);
//			if (!usinages.isEmpty()) {
//				for (var usinage : usinages) {
//					if (usinage instanceof Cavity && usinage.getName().contains("extrution sans poignee")) {
//						
//						Node knobNode = modelBuilder.node();
//						knobNode.id = "gola" + UUID.randomUUID();
//						MeshPart meshPart = new MeshPart("part" + knobNode.id,
//								golaModel.meshParts.first().mesh.copy(false), golaModel.meshParts.first().offset,
//								golaModel.meshParts.first().size, GL20.GL_TRIANGLES);
//						
//						meshPart.update();
//						modelBuilder.part(meshPart, handle.getMaterial());
//						Vector3 position = usinage.getPosition().scl(0.001f);
//						float height = (float) (usinage.getHauteurext() * 0.001f);
//						float length = (float) (design.getLongeurext() / 1000.0f);
//						Vector3 scale = new Vector3(length, height, 0.015f);
//						position.add(scale.cpy().scl(0.5f));
//						
//						knobNode.translation.set(position);
//						knobNode.rotation.set(new Quaternion());
//						knobNode.scale.set(scale);
//						knobNode.calculateTransforms(true);
//					}
//				}
//			}
		}

		Model model = modelBuilder.end();

//		for (Planche planche : planches) {
//			Node knobNode = model.getNode("knob" + planche.toString());
//			if (knobNode != null) {
//				Matrix4 handleTransform =  calculateHandlerTransform(planche, design);
//				Vector3 translation = new Vector3();
//				Quaternion rot = new Quaternion();
//				Vector3 scale = new Vector3();
//				handleTransform.getTranslation(translation);
//				handleTransform.getRotation(rot);
//				handleTransform.getScale(scale);
//				knobNode.translation.set(translation);
//				knobNode.rotation.set(rot);
//				knobNode.scale.set(scale);
//				knobNode.calculateTransforms(true);
//
//			}
//		}
		Node parent = new Node();
		parent.id = "root";
		for (Node child : model.nodes) {
			parent.addChild(child);
		}
		model.nodes.clear();
		model.nodes.add(parent);
		model.calculateTransforms();
		return model;
	}
	
//	public Matrix4 calculateHandlerTransform(Planche planche,DesignObject3D design, DoorHandle handle ) {
//		Matrix4 handleTransform = new Matrix4();
//		planche.getPieceType();
//		String pieceName = planche.getPiece2D().getName();
//		PoigneePosition poigneePosition;
//		Orientation poigneeOrientation;
//		
//		// les basculants
//		if ((design.getPorteType().equals(PortType.BASCULANT)
//				|| design.getPorteType().equals(PortType.BASCULANT2H)
//				|| design.getPorteType().equals(PortType.BASCULANT2H2P))
//				&& (planche.getPieceType() == PieceType.PORTE_BAS
//						|| planche.getPieceType() == PieceType.PORTE_HAUT)) {
//			poigneePosition = PoigneePosition.BOTTOM_MIDDLE;
//			poigneeOrientation = Orientation.HORIZONTAL;
//			// les tiroirs
//		} else if (planche.getPieceType() == PieceType.FACADE) {
//			handleTransform = getHandleTransform(design, planche, PoigneePosition.TOP_MIDDLE,
//					Orientation.HORIZONTAL, handle.getDimension());
//			// les coisn L
//		} else if (caissonType.contentEquals("BAS_COINS_L") || caissonType.contentEquals("HAUT_COINS_L")) {
//			handleTransform = getHandleTransformForLElements(design, planche, poigneePosition,
//					poigneeOrientation, handle.getDimension());
//		}
//		// H, B et colonnes
//		else {
//			// double portes
//			if (caisson.getLongeurext() > 600.0) {
//				if (caissonType.contains("COLONNE")) {
//					if (pieceName.contains("Haut")) {
//						if (!(poigneePosition.isLeft() || poigneePosition.isRight())) {
//							poigneePosition = PoigneePosition.BOTTOM_MIDDLE;
//						} else {
//							poigneePosition = pieceName.contains("Gauche") ? PoigneePosition.BOTTOM_RIGHT
//									: PoigneePosition.BOTTOM_LEFT;
//						}
//					}
//				}
//				if (!(poigneePosition.isLeft() || poigneePosition.isRight())) {
//					poigneePosition = poigneePosition.isTop() ? PoigneePosition.TOP_MIDDLE
//							: PoigneePosition.BOTTOM_MIDDLE;
//				} else {
//					if (poigneePosition.isTop()) {
//						poigneePosition = pieceName.contains("Gauche") ? PoigneePosition.TOP_RIGHT
//								: PoigneePosition.TOP_LEFT;
//					} else if (poigneePosition.isBottom()) {
//						poigneePosition = pieceName.contains("Gauche") ? PoigneePosition.BOTTOM_RIGHT
//								: PoigneePosition.BOTTOM_LEFT;
//					} else {
//						poigneePosition = pieceName.contains("Gauche") ? PoigneePosition.RIGHT_MIDDLE
//								: PoigneePosition.LEFT_MIDDLE;
//					}
//				}
//
//			} else {
//				if (pieceName.contains("Haut")) {
//					if (!(poigneePosition.isLeft() || poigneePosition.isRight())) {
//						poigneePosition = PoigneePosition.BOTTOM_MIDDLE;
//					} else {
//						poigneePosition = poigneePosition.isLeft() ? PoigneePosition.BOTTOM_LEFT
//								: poigneePosition.BOTTOM_RIGHT;
//
//					}
//				}
//
//			}
//		}
//		if (caissonType.contentEquals("BAS_COINS_L") || caissonType.contentEquals("HAUT_COINS_L")) {
//			handleTransform = getHandleTransformForLElements(design, planche, poigneePosition,
//					poigneeOrientation, handle.getDimension());
//		} else {
//			handleTransform = getHandleTransform(design, planche, poigneePosition, poigneeOrientation,
//					handle.getDimension());
//		}
//
//		return handleTransform;
//	}

	public Model createSketchFromVertices(KitchenElement object) {
		if (object.getDesignObject() == null)
			return null;
		DesignObject3D design = object.getDesignObject();
		Space3D caisson = (Space3D) design;
		ArrayList<Planche> planches = new ArrayList<Planche>();

		for (DesignObject3D designX : caisson.getListPieces()) {
			if (designX instanceof Piece2D)
				planches.add(new Planche((Piece2D) designX, object));
		}
		if (modelBuilder == null)
			modelBuilder = new ModelBuilder();
		int counter = 0;
		modelBuilder.begin();
		for (Planche planche : planches) {
			Node nodeX = modelBuilder.node();
			nodeX.id = "node_" + counter;
			planche.setVertices();
			if (planche.getPiece2D() != null) {
				PolygonBuilder.createPieceSketch(modelBuilder, planche);
			}
		}
		Model model = modelBuilder.end();
		model.calculateTransforms();
		Node root = new Node();
		root.id = "root";
		for (Node node : model.nodes) {
			root.addChild(node);
		}
		model.nodes.clear();
		model.nodes.add(root);
		return model;
	}
	
	public void createElementFeet(Planche pieceBas) {
		
	}
	
	public void createHandlers(KitchenElement facades) {
		
	}

	public Matrix4 getHandleTransform(DesignObject3D design, Planche planche, PoigneePosition poigneePosition,
			Orientation orientation, Vector3 handleDimension) {
		Matrix4 transform = new Matrix4();
		float verticalPadding = 0.03f, horizentalPadding = 0.03f;
		Vector3 translation = new Vector3(planche.getCenter()).add(0, 0, planche.getHalfExtents().z);
		Quaternion rotation = (orientation == Orientation.HORIZONTAL) ? new Quaternion()
				: new Quaternion(Vector3.Z.cpy(), 90);
		Vector3 dims = new Vector3(handleDimension);
		if (orientation == Orientation.VERTICAL) {
			dims = new Vector3(handleDimension.y, handleDimension.x, handleDimension.z);
		}
		switch (poigneePosition) {
		case TOP_LEFT:
			translation.add(horizentalPadding - planche.getHalfExtents().x + dims.x / 2.0f,
					planche.getHalfExtents().y - verticalPadding - dims.y / 2.0f, 0);
			break;
		case TOP_RIGHT:
			translation.add(-horizentalPadding + planche.getHalfExtents().x - dims.x / 2.0f,
					planche.getHalfExtents().y - verticalPadding - dims.y / 2.0f, 0);
			break;
		case TOP_MIDDLE:
			translation.add(0, planche.getHalfExtents().y - verticalPadding - dims.y / 2.0f, 0);
			break;
		case BOTTOM_LEFT:
			translation.add(horizentalPadding - planche.getHalfExtents().x + dims.x / 2.0f,
					-planche.getHalfExtents().y + verticalPadding + dims.y / 2.0f, 0);
			break;
		case BOTTOM_RIGHT:
			translation.add(-horizentalPadding + planche.getHalfExtents().x - dims.x / 2.0f,
					-planche.getHalfExtents().y + verticalPadding + dims.y / 2.0f, 0);
			break;
		case BOTTOM_MIDDLE:
			translation.add(0, -planche.getHalfExtents().y + verticalPadding + dims.y / 2.0f, 0);
			break;
		case LEFT_MIDDLE:
			translation.add(horizentalPadding - planche.getHalfExtents().x + dims.x / 2.0f, 0, 0);
			break;
		case RIGHT_MIDDLE:
			translation.add(-horizentalPadding + planche.getHalfExtents().x - dims.x / 2.0f, 0, 0);
			break;
		default:
			break;
		}
		transform.set(translation, rotation);
		return transform;
	}

	private Matrix4 getHandleTransformForLElements(DesignObject3D design, Planche planche,
			PoigneePosition poigneePosition, Orientation poigneeOrientation, Vector3 dimension) {
		Matrix4 transform = new Matrix4();
		if (planche.getPieceType().equals(PieceType.PORTE_GAUCHE)) {
			transform = getHandleTransform(design, planche, poigneePosition, poigneeOrientation, dimension);
		} else {
			Vector3 dims = new Vector3(dimension);
			if (poigneeOrientation == Orientation.VERTICAL) {
				dims.set(dimension.y, dimension.x, dimension.z);
			}
			float padding = 0.03f;
			Quaternion quat = new Quaternion(Vector3.Y.cpy(), -90);
			if (poigneeOrientation == Orientation.VERTICAL)
				quat.mul(new Quaternion(Vector3.Z.cpy(), 90));
			Vector3 translation = new Vector3(planche.getCenter());
			float heightPlacement = 0;
			if (poigneePosition.isTop()) {
				heightPlacement = planche.getHalfExtents().y - padding - dims.y / 2.0f;
			} else if (poigneePosition.isBottom()) {
				heightPlacement = -planche.getHalfExtents().y + padding + dims.y / 2.0f;
			}
			translation.add(0, heightPlacement, planche.getHalfExtents().z - padding - dims.x / 2.0f);
			transform.set(translation, quat);
		}
		return transform;
	}


	private void createGolaModel(PbrMaterial material) {
		if(material == null)
			material = ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS).get(0).cpy();
		if( !material.isReady()) {
			material.prepare();
		}
		ModelBuilder builder = new ModelBuilder();
		int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal
				| VertexAttributes.Usage.TextureCoordinates;
		golaModel = builder.createBox(1, 1, 1, material, attr);
	}

	public static DesignModelFactory getFactory() {
		if (factory == null) {
			factory = new DesignModelFactory();
		}
		return factory;
	}

	public ModelBuilder getModelBuilder() {
		return modelBuilder;
	}

}
