package dressing.handlers.cam;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.cam.model.MachineCodeHandler;
import dressing.ui.cam.parts.GcodeEditorPart;

public class SaveAsGcodeHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Inject 
	EPartService partService;
	
	@Execute
	public void execute(Shell shell,ParameterizedCommand command){
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		Object selected=null;
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				selected=project;			
			}
		}
		if(selected==null) {
			Object o = selectionService.getSelection("dressing.part.projectexplorer");
			if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject|| o instanceof Space3DFree)) {
				selected =o;
			}
		}
		final Object target=selected;
		MPart part=(MPart) partService.getActivePart();
		Object o1=part.getObject();
		if(o1 instanceof GcodeEditorPart ) {
			GcodeEditorPart editor =(GcodeEditorPart)o1;
			Object piece=editor.getPiece();
			if(piece!=null) {
				if(piece!=null && piece instanceof DesignObject3D)
				{
					 GcodeFileManager manager = new GcodeFileManager(".gcode");
					 manager.setFilepath(dirpath);
					 manager.saveworkspace(shell,(DesignObject3D) piece);
					 return;
				}	
			}
		}
			FileDialog dialog = new FileDialog(shell,SWT.SAVE);
			dialog.setFilterPath(dirpath);
			dialog.setFileName("gcode");
			String filepath = dialog.open();
			if (filepath != null && !filepath.isEmpty() && target !=null) {
				WorkspaceModifyOperation operation =	new WorkspaceModifyOperation() {
					// This is the method that gets invoked when the operation runs.
					//
					@Override
					public void execute(IProgressMonitor monitor) {
						// Save the resources to the file system.
						try {
							// Imed bug 0001710 changer l'exportation dxf dynamyque pour tout les design3D
							 GcodeFileManager manager = new GcodeFileManager(MachineCodeHandler.getInstance().getExtension());
							 if(target instanceof Kitchen) {
								 manager.saveGcode((Kitchen)target,filepath);
							 }else
								 if(target instanceof SuperCadProject) {
								 manager.saveGcode((SuperCadProject)target,filepath);
							 }else
								 if(target instanceof Space3DFree) {
									 try {
										((Space3DFree) target).refresh();
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}

									 ((Space3DFree) target).generateElementsGcode();
								 manager.saveGcode((Space3DFree)target,filepath);
							 }
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						//save file path to preference for future use
						File file = new File(filepath);
						String dirpath = file.getParent();
						 projectpref.put("directoryWrite", dirpath);
						 try {
							projectpref.flush();
						 } catch (BackingStoreException e) {
							e.printStackTrace();
						 }
						//open saved file
						try {
							Desktop.getDesktop().open(file);
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				};
				try {
					// This runs the options, and shows progress.
					//
					new ProgressMonitorDialog(shell).run(true, false, operation);

				}
				catch (Exception exception) {
					// Something went wrong that shouldn't.
					//
					exception.printStackTrace();
				}	
				
			}
		
		
	}
	@CanExecute
	public boolean check(ParameterizedCommand command)
	{ 
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				if(project !=null) {
					return true;
				}
			}
		}
		MPart part=(MPart) partService.getActivePart();
		Object o1=part.getObject();
		if(o1 instanceof GcodeEditorPart ) {
			GcodeEditorPart editor =(GcodeEditorPart)o1;
			if(editor.getPiece()!=null) {
				return true;
			}
		}
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		
		if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject || o instanceof DesignObject3D)) 
		{
			return true;
		}
		
		return false;
		
	}
}
