package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
import dressing.model.evalutor.GeometricEngineException;

public class CuisineCreator implements Creator{
String name;
Materiaux basematerial;
Materiaux backmaterial;
Cuisine cuisine;
DesignObject3D parent;
double longeur = 3000;
double hauteur = 720;
double profondeur = 560;

public double getLongeur() {
	return this.longeur;	
}

public void setLongeur(double longeur) {
	double oldValue = this.longeur;
	this.longeur = longeur;
	firePropertyChange("longeur", oldValue, longeur);
}

public double getHauteur() {
	return hauteur;
}

public void setHauteur(double hauteur) {
	double oldValue = this.hauteur;
	this.hauteur = hauteur;
	firePropertyChange("hauteur", oldValue, hauteur);
}

public double getProfondeur() {
	return profondeur;
}

public void setProfondeur(double profondeur) {
	double oldValue = this.profondeur;
	this.profondeur = profondeur;
	firePropertyChange("profondeur", oldValue, profondeur);
}
public Materiaux getBasematerial() {
	return basematerial;
}
public void setBasematerial(Materiaux basematerial) {
	
	Materiaux oldValue = this.basematerial;
	this.basematerial = basematerial;
	firePropertyChange("basematerial", oldValue, this.basematerial);
}
public Materiaux getBackmaterial() {
	return backmaterial;
}
public void setBackmaterial(Materiaux backmaterial) {
	
	Materiaux oldValue = this.backmaterial;
	this.backmaterial = backmaterial;
	firePropertyChange("backmaterial", oldValue, this.backmaterial);
}
public void setParent(DesignObject3D parent) {
	
	DesignObject3D oldValue = this.parent;
	this.parent = parent;
	firePropertyChange("parent", oldValue, parent);
}
public String getName() {
	return name;
}

public void setName(String name) {
	String oldValue = this.name;
	this.name = name;
	firePropertyChange("name", oldValue, name);
}
transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

public void addPropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(listener);
}

public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
}

public void removePropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(listener);
}

public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
}

protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
}
public void create() throws DesignException, GeometricEngineException {
	// TODO Auto-generated method stub
	createSubElements();
}
public DesignObject3D getCuisineInstance() {
	// TODO Auto-generated method stub
	return cuisine;
}
public void check() throws DesignException {

	if (getName() == null || getName().isEmpty())
		throw new DesignException("Le nom de cuisine est obligatoire");

	if (getBasematerial() == null)
		throw new DesignException("Le matérieaux de base doit être rensigné");

	if (getBackmaterial() == null)
		throw new DesignException("Le matérieaux de dos doit être rensigné");

	if (getBasematerial().getEpaisseur() <= 0)
		throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

	if (getBackmaterial().getEpaisseur() <= 0)
		throw new DesignException("L'epaisseur de matérieaux de dos doit être superieur à 1 mm");
}
public void createSubElements() throws DesignException, GeometricEngineException {
	check(); // On met le controle dans une seule fonction

	cuisine = new Cuisine();
	cuisine.setName(getName());
	cuisine.setBasematerial(getBasematerial());
	cuisine.setBackmaterial(getBackmaterial());
	cuisine.setLongeurext(getLongeur());
	cuisine.setHauteurext(getHauteur());
	cuisine.setProfondeurext(getProfondeur());
	cuisine.setParentdesign(parent);
	cuisine.constructDebitage();
	cuisine.evaluate();
}
}
