/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.viewer3d.internal;

import api.graphics.Camera;
import api.graphics.IScene;
import api.graphics.Model;
import api.graphics.ModelInstance;
import api.graphics.Shader;
import api.ui.CameraController;
import java.util.ArrayList;
import java.util.HashMap;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelViewer
implements IScene {
    private Model model3D;
    private HashMap<Model, Matrix4f[]> addons;
    private ModelInstance instance;
    private ArrayList<ModelInstance> satellites = new ArrayList();
    private Camera camera;
    private Shader shader;
    private long lastFrame;
    private CameraController cameraController;
    private Matrix4f model = new Matrix4f();
    private Vector3f dims;
    private long animationStart;
    private float angularDistance = (float)Math.PI * 2;
    private float rotationSpeed = 1.5707964f;
    private Matrix3f normal;

    public ModelViewer() {
        this.init();
    }

    public void init() {
        this.loadShader();
        this.camera = new Camera(new Vector3f(3.0f, 1.5f, 3.0f), new Vector3f(0.0f, 1.0f, 0.0f), 1.3333334f, -90.0f, 0.0f);
        this.camera.lookAt(new Vector3f());
        this.cameraController = new CameraController(this.camera);
    }

    public void loadShader() {
        String vertexShaderPath = "C:\\ProgramData\\supercad\\shaders\\preview\\vertex.glsl";
        String fragShaderPath = "C:\\ProgramData\\supercad\\shaders\\preview\\frag.glsl";
        this.shader = new Shader(vertexShaderPath, fragShaderPath);
        this.shader.use();
    }

    public void render(long delta) {
        if (this.instance != null) {
            long elapsed = System.currentTimeMillis() - this.animationStart;
            float remaining = this.angularDistance - this.rotationSpeed * (float)elapsed / 1000.0f;
            this.model.identity();
            Matrix4f transform = this.instance.getTransform();
            if (remaining > 0.0f) {
                this.model.rotate(remaining, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
                this.instance.setTransform(new Matrix4f((Matrix4fc)this.model).mul((Matrix4fc)transform));
            }
            this.shader.setMat4("vp", this.camera.GetProjectionMatrix().mul((Matrix4fc)this.camera.GetViewMatrix()));
            this.shader.setVec3("camera_position", this.camera.getPosition());
            this.instance.draw(this.shader);
            for (ModelInstance sat : this.satellites) {
                Matrix4f satTransform = sat.getTransform();
                sat.setTransform(new Matrix4f((Matrix4fc)this.instance.getTransform()).mul((Matrix4fc)satTransform));
                sat.draw(this.shader);
                sat.setTransform(satTransform);
            }
            this.instance.setTransform(transform);
        }
        this.lastFrame = System.currentTimeMillis();
    }

    private void modelChanged() {
        this.instance = new ModelInstance(this.model3D);
        Vector3f currentSize = this.instance.getBoundingBox().getSize();
        Vector3f center = this.instance.getBoundingBox().getCenter();
        Vector3f scale = new Vector3f(this.dims.x / currentSize.x, this.dims.y / currentSize.y, this.dims.z / currentSize.z);
        Matrix4f correction = new Matrix4f().translate((Vector3fc)center.mul(-1.0f)).scale((Vector3fc)scale);
        this.instance.getTransform().set((Matrix4fc)correction);
        this.animationStart = System.currentTimeMillis();
        this.rotationSpeed = 1.5707964f;
        this.satellites.clear();
        for (Model model : this.addons.keySet()) {
            Matrix4f[] matrix4fArray = this.addons.get(model);
            int n = matrix4fArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matrix4f transform = matrix4fArray[n2];
                ModelInstance instance = new ModelInstance(model);
                instance.setTransform(transform);
                this.satellites.add(instance);
                ++n2;
            }
        }
    }

    public Model getModel3D() {
        return this.model3D;
    }

    public void setModel3D(Model model3d) {
        this.model3D = model3d;
        this.modelChanged();
    }

    public void dispose() {
        this.shader.dispose();
    }

    public long getLastFrame() {
        return this.lastFrame;
    }

    public void setLastFrame(long lastFrame) {
        this.lastFrame = lastFrame;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public CameraController getCameraController() {
        return this.cameraController;
    }

    public void setCameraController(CameraController cameraController) {
        this.cameraController = cameraController;
    }

    public Vector3f getDims() {
        return this.dims;
    }

    public void setDims(Vector3f dims) {
        this.dims = dims;
    }

    public HashMap<Model, Matrix4f[]> getAddons() {
        return this.addons;
    }

    public void setAddons(HashMap<Model, Matrix4f[]> addons) {
        this.addons = addons;
    }
}

