package update;

import groovyx.net.http.HTTPBuilder;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.RESTClient;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

import org.apache.http.client.ClientProtocolException;

public class NetClientPost {

	UpdateServerConnexion connexion;
	private static int LOGINDEX = 0;
	private String logbatch = "DEFAULTBATCH";
	private String hostname = "UNKOWN";
	private String client = "UNKOWN";
	private String product = "UNKOWN";
	private String currentversion = "UNKOWN";
	public final static String LOG_DOWNLOAD_OK = "DOWNLOAD OK";
	public final static String LOG_UPDATE_OK = "UPDATE OK";
	public final static String LOG_INFO = "INFO";
	public final static String LOG_WARNING = "WARNING";
	public final static String LOG_ERROR = "ERROR";
	private boolean successerverconnexion=false;
	public NetClientPost(UpdateServerConnexion connexion) {
		super();
		this.connexion = connexion;
		Random r = new Random();
		logbatch = "" + r.nextInt(1000);
	}

	public void setHostname(String hostname) {
		this.hostname = hostname;
	}

	public void connectToServer() throws Exception {
		try
		{
		HTTPBuilder httpbuilder = new HTTPBuilder(connexion.getServerhost());
		Map postbody = new LinkedHashMap();
		postbody.put("grant_type", "password");
		postbody.put("client_id", "client");
		postbody.put("client_secret", "secret");
		postbody.put("username", connexion.getUsername());
		postbody.put("password", connexion.getPassword());
		Map postheader = new LinkedHashMap();
		postheader.put("Authorization", "Basic Y2xpZW50OnNlY3JldA==");
		postheader.put("Content-Type", "application/x-www-form-urlencoded");
		Map buildermap = new LinkedHashMap();
		buildermap.put("path", "app/rest/v2/oauth/token");
		buildermap.put("headers", postheader);
		buildermap.put("body", postbody);
		HashMap rep = (HashMap) httpbuilder.post(buildermap);
		connexion.setToken(rep.get("access_token").toString());
		System.out.println("Token : "+connexion.getToken());
		successerverconnexion = true;
		}
		//
		catch( Exception err)
		{
			System.err.println(err.getStackTrace());
			throw new Exception("Server error");
			
		}
	}

	public String getLastRelease(String client, String product, String version)
			throws Exception {

		try
		{
		RESTClient restclient = new RESTClient(connexion.getServerhost());
		Map header = new HashMap();
		header.put("Authorization", "Bearer " + connexion.getToken());
		header.put("content-type", "application/x-www-form-urlencoded");

		restclient.setHeaders(header);
		Map query = new HashMap();
		query.put("nameclient", client);
		query.put("nameproduct", product);
		query.put("numbuild", version);
		Map getmap = new HashMap();
		getmap.put("path",
				"app/rest/v2/services/interventionfrs_ReadyBuildService/lastBuildClient");
		getmap.put("query", query);

		HttpResponseDecorator rep = (HttpResponseDecorator) restclient
				.get(getmap);
		HashMap repmap = (HashMap) rep.getData();
		if (repmap != null && repmap.containsKey("etat")
				&& repmap.get("etat").equals("OK")) {
			return repmap.get("value").toString();
		} else {
			if (repmap != null) {
				System.out.println(repmap);
				if (repmap != null && repmap.containsKey("code") && repmap.get("code").equals("NOEWBUILD"))
				{
					
				}
				else
				{
					this.LogX(LOG_WARNING, "Failed to get new release  cause "+ repmap.get("message").toString());
				}
				
			} else {
				this.LogX(LOG_ERROR,"Failed  to get new release due to communication error");
			}
			return null;
		}
		
		}
		catch( Error err)
		{
					this.LogX(LOG_ERROR, "Server error");
					throw new Exception("Server error");
		}

	}

	public String preparePatch(String client, String product, String from,
			String to) throws Exception {
		try
		{
		RESTClient restclient = new RESTClient(connexion.getServerhost());
		Map header = new HashMap();
		header.put("Authorization", "Bearer " + connexion.getToken());
		header.put("content-type", "application/x-www-form-urlencoded");

		restclient.setHeaders(header);
		Map query = new HashMap();
		query.put("oldbuild", from);
		query.put("newbuild", to);
		query.put("product", product);
		Map getmap = new HashMap();
		getmap.put("path",
				"app/rest/v2/services/interventionfrs_CreatePatchBuildService/preparePatch");
		getmap.put("query", query);

		HttpResponseDecorator rep = (HttpResponseDecorator) restclient
				.get(getmap);
		HashMap repmap = (HashMap) rep.getData();
		if (repmap != null && repmap.containsKey("etat")
				&& repmap.get("etat").equals("OK")) {
			return repmap.get("value").toString();
		} else {
			if (repmap != null) {
				System.out.println(repmap);
				this.LogX(LOG_ERROR,
						"Failed  to prepare patch "
								+ repmap.get("message").toString());
			}
			return null;
		}
		
		}
		catch( Error err)
		{
				this.LogX(LOG_ERROR, "Server error");
				throw new Exception("Server error");
		}
	}

	public String registerBuild(String client, String product, String version,
			String hostname) throws Exception {

		try
		{
			RESTClient restclient = new RESTClient(connexion.getServerhost());
			Map header = new HashMap();
			header.put("Authorization", "Bearer " + connexion.getToken());
			header.put("content-type", "application/x-www-form-urlencoded");

			restclient.setHeaders(header);
			Map query = new HashMap();
			query.put("nameclient", client);
			query.put("nameproduct", product);
			query.put("numbuild", version);
			query.put("nameposte", hostname);
			Map getmap = new HashMap();
			getmap.put(
					"path",
					"app/rest/v2/services/interventionfrs_InstalledBuildService/createInstalledBuild");
			getmap.put("query", query);

			HttpResponseDecorator rep = (HttpResponseDecorator) restclient
					.get(getmap);
			HashMap repmap = (HashMap) rep.getData();
			if (repmap != null && repmap.containsKey("etat")
					&& repmap.get("etat").equals("OK")) {
				return repmap.get("value").toString();
			} else {
				if (repmap != null) {
					System.out.println(repmap);
					this.LogX(LOG_WARNING,"Failed to register cause "	+ repmap.get("message").toString());
				} else {
					this.LogX("Failed to register due to communication error");
				}
				return null;
			}
		}
		catch( Error err)
		{
			this.LogX(LOG_ERROR, "Server error");
			throw new Exception("Server error");
		}
		
	}

	public void setClient(String client) {
		this.client = client;
	}

	public void setProduct(String product) {
		this.product = product;
	}

	public void setCurrentversion(String currentversion) {
		this.currentversion = currentversion;
	}

	

	public InputStream getStreamDownload(String downloadpath) throws Exception {

		try
		{
			String url = connexion.getServerhost()
					+ "app-portal/rest/downloadpatch/download?pathfile="
					+ downloadpath;
			System.out.println("Connecting to stream file " + url);
			RESTClient restclient = new RESTClient(url);

			Map getmap = new HashMap();

			HttpResponseDecorator rep = (HttpResponseDecorator) restclient
					.get(getmap);
			ByteArrayInputStream repmap = (ByteArrayInputStream) rep.getData();
			// Probleme dans la taille egale zero

			InputStream in = repmap;// your ByteArrayInputStream here
			System.out.println("Connecting to stream file succes");
			return in;
		}
		catch(Exception exp )
		{
			this.LogX(LOG_ERROR, "Failed to get stream from server for the path "+downloadpath+ " Exception "+exp.getMessage() );
			throw exp;
		}
		catch( Error err)
		{
			this.LogX(LOG_ERROR, "Failed to get stream from server for the path "+downloadpath+ "Error  "+err.getMessage() );
			throw new Exception("Server error");
		}
	
	}

	public Long getFileSize(String downloadpath) throws Exception {

		try
		{
			String url = connexion.getServerhost()
					+ "app-portal/rest/downloadpatch/checksize?pathfile="
					+ downloadpath;
			System.out.println("Connecting to stream file " + url);
			RESTClient restclient = new RESTClient(url);

			Map getmap = new HashMap();

			HttpResponseDecorator rep = (HttpResponseDecorator) restclient
					.get(getmap);
			ByteArrayInputStream repmap = (ByteArrayInputStream)rep.getData();
			// Probleme dans la taille egale zero
			int n = repmap.available();
			byte[] bytes = new byte[n];
			repmap.read(bytes, 0, n);
			String s = new String(bytes, StandardCharsets.UTF_8); // Or any encoding.
			String str = s;
			try {
				Long size = Long.parseLong(str) ;
				return size;
			} catch (Exception e) {
				// TODO: handle exception
				e.printStackTrace();
				return -1L;
			}
			
		
			
		}
		catch(Exception exp )
		{
			this.LogX(LOG_ERROR, "Failed to get file size for the path "+downloadpath);
			throw exp;
		}
		catch( Error err)
		{
			this.LogX(LOG_ERROR, "Failed to get file size   for the path "+downloadpath);
			throw new Exception("Server error");
		}
	
	}
	public void LogX(String loglevel, String message) {
		try {
			RESTClient restclient = new RESTClient(connexion.getServerhost());
			Map header = new HashMap();
			header.put("Authorization", "Bearer " + connexion.getToken());
			header.put("content-type", "application/x-www-form-urlencoded");

			restclient.setHeaders(header);
			Map query = new HashMap();
			query.put("nameclient", this.client);
			query.put("nameproduct", this.product);
			query.put("message", message);
			query.put("fromversion", this.currentversion);
			query.put("logbatch", logbatch);
			query.put("logindex", "" + (LOGINDEX++));
			query.put("hostname", this.hostname);
			query.put("loglevel", loglevel);

			Map getmap = new HashMap();
			getmap.put("path",
					"app/rest/v2/services/interventionfrs_InstalledBuildService/logInstalledBuild");
			getmap.put("query", query);

			HttpResponseDecorator rep = (HttpResponseDecorator) restclient
					.get(getmap);
			HashMap repmap = (HashMap) rep.getData();
			if (repmap != null && repmap.containsKey("etat")
					&& repmap.get("etat").equals("OK")) {
				// System.out.println("Log X Succesed");
			} else {
				System.out.println("Log X Server Error");
			}
		} catch (Exception e) {
			// TODO: handle exception
			System.out.println("Log X Failed");
		}
		catch( Error err)
		{
			System.out.println("Server Error");
		}

	}

	public void LogX(String message) {
		LogX(LOG_INFO, message);
	}
	public boolean isSuccesserverconnexion() {
		return successerverconnexion;
	}

	public String prepareReport(String client2, String product2,String version) {
		RESTClient restclient;
		try {
			restclient = new RESTClient(connexion.getServerhost());
		
		Map header = new HashMap();
		header.put("Authorization", "Bearer " + connexion.getToken());
		header.put("content-type", "application/x-www-form-urlencoded");

		restclient.setHeaders(header);
		Map query = new HashMap();
		query.put("product", product2);
		query.put("client", client2);
		query.put("numbuid", version);
		Map getmap = new HashMap();		
		getmap.put("path","app/rest/v2/services/interventionfrs_CreatePatchBuildService/getMyReportScom");
		getmap.put("query", query);

		HttpResponseDecorator rep = (HttpResponseDecorator) restclient.get(getmap);
		HashMap repmap = (HashMap) rep.getData();
		if (repmap != null && repmap.containsKey("etat")
				&& repmap.get("etat").equals("OK")) {
			return repmap.get("value").toString();
		} else {
			if (repmap != null) {
				System.out.println(repmap);
				this.LogX(LOG_WARNING,"Failed to prepare reports "	+ repmap.get("message").toString());
			} else {
				this.LogX("Failed to prepare reports due to communication error");
			}
			return null;
		}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			this.LogX("Failed to prepare reports due to communication error");
			e.printStackTrace();
			return null;
		}
	}

	
	public String getLastRelease(String product) {
		RESTClient restclient;
		try {
			restclient = new RESTClient(connexion.getServerhost());		
		Map header = new HashMap();
		header.put("Authorization", "Bearer " + connexion.getToken());
		header.put("content-type", "application/x-www-form-urlencoded");
		
		
		restclient.setHeaders(header);
		Map query = new HashMap();
		query.put("nameproduct", product);
		Map getmap = new HashMap();
		getmap.put(	"path","app/rest/v2/services/interventionfrs_BuildService/getLastReleaseBuild");
		getmap.put("query", query);

		HttpResponseDecorator rep = (HttpResponseDecorator) restclient.get(getmap);
		HashMap repmap = (HashMap) rep.getData();
		if (repmap != null && repmap.containsKey("etat")
				&& repmap.get("etat").equals("OK")) {
			return repmap.get("value").toString();
		} else {
			if (repmap != null) {
				System.out.println(repmap);
				this.LogX(LOG_WARNING,"Failed to get last release "	+ repmap.get("message").toString());
			} else {
				this.LogX("Failed to get last release due to communication error");
			}
			return null;
		}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			this.LogX("Failed to get last release due to communication error");
			e.printStackTrace();
			return null;
		}
	}
}

