package gdxapp.object3d;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;

import dressing.controller.tools.ToolController;
import dressing.model.ProjectManager;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.PlinthCreationWindow;
import gdxapp.Commun.GroupSelection;

public class GeometricObjectEventProcessor extends Object2DEventProcessor{
	
	private Plinth plinth;
	private long lastClickDate;
	
	
	
	public GeometricObjectEventProcessor(Plinth plinth) {
		super(plinth);
		this.plinth = plinth;
	}

	@Override
	public boolean handle(Event e) {
		if (!ToolController.getInstance().isSELECT_Objects()) {
			return false;
		}

		if (!(e instanceof InputEvent))
			return false;
		InputEvent event = (InputEvent) e;
		if (event.getType().equals(InputEvent.Type.touchDragged)) {
			if (GroupSelection.getInstance().getSelection() != null) {
				if (GroupSelection.getInstance().getSelection().size() > 1) {
					return false;
				}
			}
		}
		
		if (plinth!=null && plinth.getStage() != null) {
			plinth.getStage().setKeyboardFocus(plinth);
			return super.handle(e);
		}
	
		return false;
	}

	@Override
	public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
		if (Gdx.input.isKeyPressed(Keys.CONTROL_LEFT)) {
			GroupSelection.getInstance().toggleSelection(this.plinth);
		} else {
			GroupSelection.getInstance().clearSelection();
			GroupSelection.getInstance().addObject(this.plinth);
		}
		long newClickDate = System.currentTimeMillis();
		long timeSinceLastClick = newClickDate - lastClickDate;
		lastClickDate = newClickDate;

		if (plinth != null && plinth.getPlinthObject() != null && button == Input.Buttons.LEFT) {
			if (timeSinceLastClick < 250) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
							PlinthCreationWindow window = new PlinthCreationWindow(GdxPart.parentShell, plinth.getPlinthObject());
							window.open();
						}
					});
			}
		}
		return true;
	}





	
	
}
