package dressing.ui.charniere;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import dressing.controller.CharniereCreator;
import dressing.model.Charniere;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.evalutor.GeometricEngineException;

public class CharniereWizardPage extends WizardPage {

	CharniereCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	
	public CharniereCreator getCreator() {
		return creator;
	}
	public void SetCreator(CharniereCreator creator) {
		this.creator = creator;
	}
	/**
	 * Create the wizard.
	 */

	
	public CharniereWizardPage(String pageName, CharniereCreator creator) {
		super(pageName);
		setTitle("Créer un nouveau Bloc Tiroir");
		setDescription("Veuillez renseigner les propriétés de  Bloc Tiroir ");
		setPageComplete(false);
		SetCreator(creator);
	}
	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		CharniereWizardComposite container = new CharniereWizardComposite(parent, SWT.BORDER,creator);
	
		setControl(container);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						creator.create();
						for(Charniere ch: creator.getListCharniere()) {
							for(DesignObject3D tr:ch.getBabies()) {
								tr.getParentdesign().deletechild(tr);
							}
						}
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre cuisine", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		creator.addPropertyChangeListener(pcl);
	
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = !errorfound;
		return b;
	}
	public void clearlistners() {
		creator.removePropertyChangeListener(pcl);
	}
}
