package dressing.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import dressing.model.evalutor.Couple;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.IntersectionType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Usinage;

public class Space3D extends DesignObject3D {
	Zone3DType zonetype;
	DosType dostype;
	PortType porttype;
	CaissonMontageType caissonMontageType= CaissonMontageType.CAISSON_MONTAGE_I;
	
	
	public CaissonMontageType getCaissonMontageType() {
		return caissonMontageType;
	}

	public void setCaissonMontageType(CaissonMontageType caissonMontageType) {
		CaissonMontageType oldValue = this.caissonMontageType;
		this.caissonMontageType = caissonMontageType;
		firePropertyChange("caissonMontageType", oldValue, caissonMontageType);
	}
	
	public PortType getPorttype() {
		return porttype;
	}

	public void setPorttype(PortType porttype) {
		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}

	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}

	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}

	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}

	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}

//public double gettransparency() {
//	return 0.2;
//}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return true;
	}
public void setZonetype(Zone3DType zonetype) {
	Zone3DType oldValue = this.zonetype;
	this.zonetype = zonetype;
	firePropertyChange("zonetype", oldValue, zonetype);
}
public Zone3DType getZonetype() {
	return zonetype;
}

public DosType getDostype() {
	return dostype;
}

public void setDostype(DosType dostype) {

	DosType oldValue = this.dostype;
	this.dostype = dostype;
	firePropertyChange("dostype", oldValue, dostype);
}

@Override
public boolean isdrawable() {
	// TODO Auto-generated method stub
	return false;
}
 public boolean ishasdos() {
	 for(DesignObject3D piece:getChilds()) {
			if(piece instanceof Piece2D &&((Piece2D)piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
				return true;
			}
		}
	return false;
	 
 }
/**
 * Le this est le grand espace
 * 
 * @param le sous espace contenue
 * @return
 */
public boolean contains(Space3D o) {
	// TODO Auto-generated method stub
	if(o.getXPosABS()>= this.getXPosABS()
	   && 	o.getYPosABS()>= this.getYPosABS()
	   && 	o.getZPosABS()>= this.getZPosABS())
	{
		
		
		if(o.getXPosABS() + o.getXSize() <= this.getXPosABS() + this.getXSize() 
			&& o.getYPosABS() + o.getYSize() <= this.getYPosABS() + this.getYSize() 
			&& o.getZPosABS() + o.getZSize() <= this.getZPosABS() + this.getZSize() )
		{
			return true;
		}
	}
	
	
	return false;
}

	@Override
	public DesignObject3D clone() {
		Space3D space=new Space3D();
		try {
			space=(Space3D) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException |CloneNotSupportedException e ) {
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Space3D space =(Space3D) object;
		 space.setUsineparam(getUsineparam());
		 space.setConstraintsparam(getConstraintsparam());
		 space.copyParams(getParams());
		 space.setLongeurext(getLongeurext());
		 space.setLongeurextfree(isLongeurextfree());
		 space.setProfondeurext(getProfondeurext());
		 space.setProfondeurextfree(isProfondeurextfree());
		 space.setHauteurext(getHauteurext());
		 space.setHauteurextfree(isHauteurextfree());
		 space.setLongeurint(getLongeurint());
		 space.setProfondeurint(getProfondeurint());
		 space.setHauteurint(getHauteurint());
		 space.setName(getName());
		 space.setBasematerial(getBasematerial());
		 space.setBasematerialfree(isBasematerialfree());
		 space.setBackmaterial(getBackmaterial());
		 space.setBackmaterialfree(isBackmaterialfree());
		 space.setFacadeMaterial(getFacadeMaterial());
		 space.setFacadematerialfree(isFacadematerialfree());
		 space.setXpos(getXpos());
		 space.setYpos(getYpos());
		 space.setZpos(getZpos());
		 space.setXPosABS(getXPosABS());
		 space.setYPosABS(getYPosABS());
		 space.setZPosABS(getZPosABS());
		 space.setZonetype(getZonetype());
		 space.setDostype(getDostype());
		 space.setPorttype(getPorttype());
		 space.setCaissonMontageType(getCaissonMontageType());
		 space.setProps(getProps());
		 space.systemesequations=this.systemesequations;
		 space.systemesequationsasparent=this.systemesequationsasparent;
		 space.setID(getID());
		 for(DesignObject3D design:getChilds() ) {
			 space.addElement(design.clone());			
		 }
		 for(DesignObject3D design:space.getChilds()) {
				if(design instanceof Separator) {
					Separator sep=(Separator) design;
					sep.setParentspace(space);
				}
			}
		return space;
	}
	
	public List<Piece2D> getIntersectedPieces(Space3D space,DesignObject3D frere) {
		 List<Piece2D> intesectedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D || child instanceof Separator) {
				intesectedPiece.addAll(getIntersectedPieces(space, child)) ;
			}
			if(child instanceof Piece2D && !space.equals(child)) {
				if(space.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
					intesectedPiece.add((Piece2D) child);
				}
			}
		}
		return intesectedPiece;
		
	}
	/**
	 * chercher pour le caisson root , si cette espace un caisson on vas la retourner,
	 * si ce espace est un cuisine ou dressing on retourner null car ces composant de haut degrer et impossible ces objet peut etre contenue 
	 * dans un caisson 
	 * sinon on chercher pour les caison dans le parent et ce parent ... 
	 * @return root caisson
	 */
	public DesignObject3D getRootCaisson() {
		if(this instanceof Caisson) {
			return this;
		}
		if(this instanceof Space3DFree) {
			return this;
		}
		if(this instanceof Dressing || this instanceof Cuisine ) {
			return null;
		}
		DesignObject3D parent= this.getParentdesign();
		if(parent == null) {
			return this;
		}
		while(parent!= null && !(parent instanceof Caisson)&& !(parent instanceof Space3DFree)) {
			parent=parent.getParentdesign();
		}
		return parent;
		
	}
	
	/**
	 * supprimer les usinages et les accessoire 
	 */
	@Override
	public void deleteUsinage() throws GeometricEngineException, DesignException {
		List<DesignObject3D>childstobeDeleted =new ArrayList<DesignObject3D>();
		List<DesignObject3D> babiestobeDeleted =new ArrayList<DesignObject3D>();
		
		//collecter les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:getChilds()) {
			
			if((design instanceof Usinage)|| (design instanceof Accessoire)) {
				childstobeDeleted.add(design);
			}
		}
		//collecter les usinage qui référence sur cette piece comme mother 
		if(getBabies()!=null) {
			for(DesignObject3D design:getBabies()) {
				
				if((design instanceof Usinage)|| (design instanceof Accessoire)) {
					babiestobeDeleted.add(design);
				}
			}	
		}
				
		//supprimer tout les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:childstobeDeleted) {	
			
			deletechild(design);
		}
		//supprimer tout les usinage qui référence sur cette piece comme mother 
		for(DesignObject3D design:babiestobeDeleted) {	
			
			removeBaby(design);
		}
		super.deleteUsinage();
	}
	
	@Override
	public ArrayList<Couple> getSystemEquationAsParent() {
		// TODO Auto-generated method stub
		systemesequationsasparent.clear();
		systemesequationsasparent.add(new Couple("@Parent.l@", ""+getLongeurext()));
		systemesequationsasparent.add(new Couple("@Parent.p@", ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple("@Parent.h@", ""+getHauteurext()));
		systemesequationsasparent.add(new Couple("@Parent.li@", ""+getLongeurint()));
		systemesequationsasparent.add(new Couple("@Parent.pi@", ""+getProfondeurint()));
		systemesequationsasparent.add(new Couple("@Parent.hi@", ""+getHauteurint()));
		
		systemesequationsasparent.add(new Couple("@Parent.epaisseursecondaire@", ""+getBackmaterial().getEpaisseur()));
		systemesequationsasparent.add(new Couple("@Parent.epaisseurprincipale@", ""+getBasematerial().getEpaisseur()));

		systemesequationsasparent.add(new Couple("@Parent.posx@", ""+getXpos()));
		systemesequationsasparent.add(new Couple("@Parent.posy@", ""+getYpos()));
		systemesequationsasparent.add(new Couple("@Parent.posz@", ""+getZpos()));
		

		return systemesequationsasparent;
 	}

	
	public String getDebitageDescription() {
		String description="";
		List<Piece2D> pieces=getListPieces();
		Map<Materiaux, List<Piece2D>> map=new HashMap<Materiaux, List<Piece2D>>();
		for(Piece2D piece:pieces) {
			Materiaux mat=piece.getMaterial();
			if(map.containsKey(mat)) {
				map.get(mat).add(piece);
			}else {
				List mats= new ArrayList<Piece2D>();
				mats.add(piece);
				map.put(mat,mats);
				
			}
		}
		
		
		for(Materiaux mat : map.keySet()) {
			description+=mat.getName()+"\n";
			for(Piece2D piece:map.get(mat)) {
				description+=piece.getName()+"\t"+piece.getPieceL()+"X"+piece.getPieceH()+"\n";
			}
		}
		return description;
	}
	
	
	
}
