package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.ui.library.ExportModelWizard;
import dressing.ui.library.ImportModelWizard;

/**
 * @Bug 0001846 
 * importer un caisson depuis la bibliothèque
 * @author Imed
 *
 */
public class ImportModelFromLibraryHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){
		Object selection = selectionService.getSelection("dressing.part.tree");
		Cuisine cuisine=(Cuisine) selection;
		ImportModelWizard exportModelWizard = ContextInjectionFactory.make(ImportModelWizard.class,eclipsecontext);
		exportModelWizard.setCuisine(cuisine);
		WizardDialog dialog = new WizardDialog(shell, exportModelWizard);
		dialog.open();
		
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		if(o!=null && o instanceof Cuisine )
		{
			return true;
		}	
		return false;
	}

}
