package tech.frsdev.j3d;

import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Text3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Vector3d;

import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.types.SeprationAxe;
import tech.frsdev.solids.Solide3D;

public class InternalDimDraw extends DimDraw{
    public InternalDimDraw(Solide3D solid, double refsize) {
		super(solid, refsize);
		init();
	}
	protected Text3D tex = new Text3D(); ;
    protected Shape3D shapetext = new Shape3D();
    protected TransformGroup tftext = new TransformGroup();
    protected Transform3D tf3 = new Transform3D();

    
    @Override
    protected void regenratecotes(float xp0, float yp0, float zp0) {
    	// TODO Auto-generated method stub
    	
    	if (solid instanceof Space3D)
			{			
				Space3D sp3d = (Space3D) solid;
				if(sp3d.getParentdesign() instanceof Separator)
				{
				Separator sep = (Separator)sp3d.getParentdesign();
				if(sep.getSepaxe().equals(SeprationAxe.XAXIS))
				{		
				    // Build 3D text geometry using the 3D font
				    tex.setFont3D(font3d);
				    tex.setString(""+(int)sp3d.getLongeurint());		    
				    tex.setAlignment(Text3D.ALIGN_CENTER);
				
				    shapetext = new Shape3D(tex, appearancetext);
				    tftext = new TransformGroup();
				    tf3 = new Transform3D();
				    tf3.setScale(0.02);
				    tf3.setTranslation(new Vector3d(xp0-0.025,yp0-0.025, zp0));
				    tftext.addChild(shapetext);
				    tftext.setTransform(tf3);
				    
				    holdingbox.addChild(tftext);
				    
					tex.setCapability(Text3D.ALLOW_STRING_WRITE);
					shapetext.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
					shapetext.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
					tftext.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
				}
				
				else if(sep.getSepaxe().equals(SeprationAxe.YAXIS))
				{		
				    // Build 3D text geometry using the 3D font
				    tex.setFont3D(font3d);
				    tex.setString(""+(int)sp3d.getHauteurint());		    
				    tex.setAlignment(Text3D.ALIGN_CENTER);
				
				    shapetext = new Shape3D(tex, appearancetext);
				    tftext = new TransformGroup();
				    
				    Transform3D rotate = new Transform3D();
				    rotate.rotZ(Math.PI/2);
				    tf3 = new Transform3D();
				    tf3.setScale(0.02);
				    tf3.setTranslation(new Vector3d(-xp0+0.025, -yp0+0.025, zp0));
				    tf3.mul(rotate);
				    tftext.addChild(shapetext);
				    tftext.setTransform(tf3);	
				    holdingbox.addChild(tftext);
				    
					tex.setCapability(Text3D.ALLOW_STRING_WRITE);
					shapetext.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
					shapetext.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
					tftext.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
				}
		}
    }
}
    @Override
    protected void redrawcotes(float xp0,float yp0,float zp0)
	{
    		if( solid instanceof Space3D )
			{
				Space3D sp3d = (Space3D) solid;
				if(sp3d.getParentdesign() instanceof Separator)
				{
					Separator sep = (Separator)sp3d.getParentdesign();
					if(sep.getSepaxe().equals(SeprationAxe.XAXIS))
					{	
					    tex.setString(""+(int)sp3d.getLongeurint());	
					}
					
					else if(sep.getSepaxe().equals(SeprationAxe.YAXIS))
					{	
					    tex.setString(""+(int)sp3d.getHauteurint());	
					}
				}
				

			}
    		
	}   
}
