package tech.frsdev.j3d;

import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Text3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3d;

import dressing.model.Caisson;
import dressing.model.Dressing;
import dressing.model.Space3D;
import tech.frsdev.solids.Solide3D;

public class ExternalDimDraw extends DimDraw{
	protected Text3D texX = new Text3D(); ;
    protected Shape3D shapetextX = new Shape3D();
    protected TransformGroup tftextX = new TransformGroup();
    protected Transform3D tf3X = new Transform3D();
    protected LineArray lineX;
    protected Shape3D shape3dX = new Shape3D();
    
	protected Text3D texY = new Text3D(); ;
    protected Shape3D shapetextY = new Shape3D();
    protected TransformGroup tftextY = new TransformGroup();
    protected Transform3D tf3Y = new Transform3D();
    protected LineArray lineY;
    protected Shape3D shape3dY = new Shape3D();
    
    boolean drawx=true;
    boolean drawy=true;
    float scalefactor = 1.3f;
	public ExternalDimDraw(Solide3D solid, double refsize,float scalefactor) {
		super(solid, refsize);
		// TODO Auto-generated constructor stub
		this.scalefactor = scalefactor;
		
		init();
	}
	public ExternalDimDraw(Solide3D solid, double refsize,boolean drawx,boolean drawy,float scalefactor) {
		super(solid, refsize);
		// TODO Auto-generated constructor stub
		this.drawx = drawx;
		this.drawy = drawy;
		this.scalefactor = scalefactor;
		init();
	}
	@Override
	protected void regenratecotes(float xp0,float yp0,float zp0)
	{
				if(drawx)
				{
				    texX.setFont3D(font3d);
				    texX.setString(""+(int)solid.getXSize());		    
				    texX.setAlignment(Text3D.ALIGN_CENTER);			
				    shapetextX = new Shape3D(texX, appearancetext);
				    tftextX = new TransformGroup();
				    tf3X = new Transform3D();
				    tf3X.setScale(0.03);
				    tf3X.setTranslation(new Vector3d(0f, this.scalefactor*yp0, zp0));
				    tftextX.addChild(shapetextX);
				    tftextX.setTransform(tf3X);
				    
				    holdingbox.addChild(tftextX);
				    
				    lineX = new LineArray(6, LineArray.COORDINATES);
					lineX.setCoordinate(0, new Point3f(xp0, (float) (this.scalefactor*yp0), zp0));
					lineX.setCoordinate(1, new Point3f(-xp0  , (float) (this.scalefactor*yp0), zp0));				
					lineX.setCoordinate(2, new Point3f(-xp0  , (float) (this.scalefactor*yp0), zp0));
					lineX.setCoordinate(3, new Point3f(-xp0  , yp0, zp0));				
					lineX.setCoordinate(4, new Point3f(xp0  , (float) (this.scalefactor*yp0), zp0));
					lineX.setCoordinate(5, new Point3f(xp0  , yp0, zp0));
					lineX.setCapability(LineArray.ALLOW_COORDINATE_WRITE);
					shape3dX = new Shape3D(lineX,appearancetext);
					holdingbox.addChild(shape3dX);
					
					texX.setCapability(Text3D.ALLOW_STRING_WRITE);
					shapetextX.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
					shapetextX.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
					tftextX.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
				}
				if(drawy)
				{
					
				    texY.setFont3D(font3d);
				    texY.setString(""+(int)solid.getYSize());		    
				    texY.setAlignment(Text3D.ALIGN_CENTER);
				
				    shapetextY = new Shape3D(texY, appearancetext);
				    tftextY = new TransformGroup();
				    
				    Transform3D rotate = new Transform3D();
				    rotate.rotZ(Math.PI/2);
				    tf3Y = new Transform3D();
				    tf3Y.setScale(0.03);
				    tf3Y.setTranslation(new Vector3d(-this.scalefactor*xp0, 0f, 0f));
				    tf3Y.mul(rotate);
				    tftextY.addChild(shapetextY);
				    tftextY.setTransform(tf3Y);
				    
				    
				    lineY = new LineArray(6, LineArray.COORDINATES);
					lineY.setCoordinate(0, new Point3f((float) (-this.scalefactor*xp0), yp0, zp0));
					lineY.setCoordinate(1, new Point3f((float) (-this.scalefactor*xp0)  , -yp0, zp0));
					
					lineY.setCoordinate(2, new Point3f((float) (-this.scalefactor*xp0), yp0, zp0));
					lineY.setCoordinate(3, new Point3f((float) (-1*xp0)  , yp0, zp0));
					
					lineY.setCoordinate(4, new Point3f((float) (-this.scalefactor*xp0), -yp0, zp0));
					lineY.setCoordinate(5, new Point3f((float) (-1*xp0)  , -yp0, zp0));
					lineY.setCapability(LineArray.ALLOW_COORDINATE_WRITE);
					shape3dY = new Shape3D(lineY,appearancetext);
					holdingbox.addChild(shape3dY);					
				    holdingbox.addChild(tftextY);
				    
					texY.setCapability(Text3D.ALLOW_STRING_WRITE);
					shapetextY.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
					shapetextY.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
					tftextY.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
				}
						
		}
	
	@Override
	protected void redrawcotes(float xp0, float yp0, float zp0) {
		// TODO Auto-generated method stub
		if( solid instanceof Space3D)
		{		
			if(drawx)
		    texX.setString(""+(int)solid.getXSize());	
			if(drawy)
			texY.setString(""+(int)solid.getYSize());	
		}
	}
}
