package reporting.htmlReporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import com.badlogic.gdx.Gdx;
import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import dressing.reporting.data.handle.ProjectCoupe;
import dressing.reporting.data.handle.ReportConfigDialog;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;
import utils.CompleatbleRunnable;

public class SingleDocKitchenReport extends HtmlReport {

	private final String template_path = "src/reporting/htmlReporting/templates/debi-devis.html";
	private SuperCadProject project;
	private String reportDir;
	private Map<KitchenElement, String[]> picturesPath = new HashMap<KitchenElement, String[]>();
	private List<String> wallViewsUrl;
	private HashMap<DesignObject3D, ElementReport> elementsReport;
	private HashMap<ElementReport, String> links;
	private ProjectCoupe projectCoupe;
	private String screenShotURI;
	private String schemaURI;

	public SingleDocKitchenReport(SuperCadProject project) {
		super();
		this.project = project;
		this.projectCoupe = new ProjectCoupe(true, project);
		this.reportDir = project.getProjectDirectory() + File.separator + "reporting";
	}

	public void prepareData() {
		
		//data for project part
		FileDialog fileDialog = new FileDialog(shell, SWT.SINGLE);
		fileDialog.setText("Choisir Image pour la Cuisine");
		fileDialog.setFilterExtensions(new String[] { "*.png", "*.jpg", "*.jpeg", "*.gif" });
		String result = fileDialog.open();
		if (result == null || result.isEmpty())
			return;
		File file = new File(result);
		String destination = ProjectManager.getManager().getCurrentProject().getProjectDirectory();
		destination = destination + File.separator + "reporting" + File.separator + "screenshot.png";
		File destFile = new File(destination);
		destFile.getParentFile().mkdirs();
		try {
			destFile.createNewFile();
			IOUtilities.copyFileUsingChannel(file, destFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
		this.screenShotURI = destFile.getAbsolutePath();
		
		fileDialog = new FileDialog(shell, SWT.SINGLE);
		fileDialog.setText("Choisir Schéma technique:");
		fileDialog.setFilterExtensions(new String[] { "*.png", "*.jpg", "*.jpeg", "*.gif" });
		result = fileDialog.open();
		if (result == null || result.isEmpty())
			return;
		file = new File(result);
		destination = ProjectManager.getManager().getCurrentProject().getProjectDirectory();
		destination = destination + File.separator + "reporting" + File.separator + "schema.png";
		destFile = new File(destination);
		destFile.getParentFile().mkdirs();
		try {
			destFile.createNewFile();
			IOUtilities.copyFileUsingChannel(file, destFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
		this.schemaURI = destFile.getAbsolutePath();
		
		wallViewsUrl = new ArrayList<String>();
		CompleatbleRunnable task = new CompleatbleRunnable() {
			@Override
			public void run() {
				try {
					for (KitchenElement element : ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
						element.generateImages();
					}
					wallViewsUrl.addAll(Room3DController.getInstance().takeWallViews());
				} catch (Exception e) {
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							MessageDialog.openError(shell, "error", "failed to create report!\n" + e.getMessage());
						}
					});
				}
				unlock();
			}
		};
		Gdx.app.postRunnable(task);
		task.waitForComplete();
		createURI();
		//data for devis
		ReportConfigDialog dialog = new ReportConfigDialog(shell, projectCoupe.getTotals());
		dialog.open();
	}

	public void createURI() {
		String host = WorkspaceConfiguration.JETTY_HOST;
		// screenshot
		File file = new File(this.screenShotURI);
		this.screenShotURI = host + "/" + file.getName();
		file = new File(this.schemaURI);
		this.schemaURI = host + "/" + file.getName();
		// elements pictures
		picturesPath.clear();
		for(KitchenElement element: ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
			String[] paths= new String[2];
			File  imgFile  = new File(element.getPathToBackImage());
			paths[0] = host + File.separator + imgFile.getName();
			imgFile = new File(element.getPathToFrontImage());
			paths[1] = host + File.separator + imgFile.getName();
			picturesPath.put(element, paths);
		}
	}

	@Override
	public void bind() throws Exception {
		prepareData();
		// binding for devis
		bindDevisPart();
		bindDebitagePart();

	}

	public void bindDevisPart() {
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		boolean isShowCost = ReportingPreferences.getInstance().getProperty("report.showcost", false);
		this.binding.put("$projectCoupe$", projectCoupe);
		this.binding.put("$logoPath$", WorkspaceConfiguration.JETTY_HOST + "/" + "logo.png");
		this.binding.put("$isShowAccessoire$", isShowAccessoire);
		this.binding.put("$isShowQuicaillerie$", isShowQuicaillerie);
		this.binding.put("$isShowCost$", isShowCost);
	}

	public void bindDebitagePart() {
		File logoFile = new File(ModelProvider.getModelroot().getConfig().getLogoPath());
		File logoDestination = new File(reportDir + File.separator + "logo.png");
		try {
			IOUtilities.copyFileUsingChannel(logoFile, logoDestination);
			binding.put("$logo$", WorkspaceConfiguration.JETTY_HOST + "/" + logoDestination.getName());
		} catch (IOException e) {
			e.printStackTrace();
		}
		binding.put("$project$", this.project);
		binding.put("$creation_date$", this.project.getCreationDate().toLocalDate());
		binding.put("$faceUrls$", wallViewsUrl);
		List<DesignObject3D> elements = new ArrayList<DesignObject3D>(this.project.getKitchens().get(0).getElements());
		ArrayList<DesignObject3D> fakeFacades = new ArrayList<DesignObject3D>();
		for (DesignObject3D design : elements) {
			String type = design.getDesignCaissonType();
			if (type.equals("FAUSSE_FACADE"))
				fakeFacades.add(design);
		}
		elements.removeAll(fakeFacades);

		binding.put("$elements$", elements);
		binding.put("$fake_facades$", fakeFacades);
		binding.put("$capture$", this.screenShotURI);
		binding.put("$schema$", this.schemaURI);
		elementsReport = new HashMap<DesignObject3D, ElementReport>();
		links = new HashMap<ElementReport, String>();
		String tmpFolderPath = "elements";
		for (KitchenElement element : project.getKitchens().get(0).getScene().getKitchenElements()) {
			ElementReport eltReport = new ElementReport(element);
			try {
				eltReport.setPathToBackImg(picturesPath.get(element)[0]);
				eltReport.setPathToFrontImg(picturesPath.get(element)[1]);
			}catch (Exception e) {
				System.out.println("error in fetching element pictures!");
			}
			eltReport.bind();
			eltReport.generate(false);
			elementsReport.put(element.getDesignObject(), eltReport);
			UUID id = UUID.randomUUID();
			String path = tmpFolderPath + File.separator + id + ".html";
			links.put(eltReport, path);
		}
		binding.put("$reports$", elementsReport);
		binding.put("$links$", links);
		binding.put("$kitchen$", project.getKitchens().get(0));
	}
	
	
	
	@Override
	public String export(String path) {
		String folder = new File(path).getParentFile().getAbsolutePath();
		writeElementReports(new File(folder));
		return super.export(path);
	}

	private void writeElementReports(File tmpFolder) {
		for(KitchenElement element: project.getKitchens().get(0).getScene().getKitchenElements() ) {
			ElementReport report = elementsReport.get(element.getDesignObject());
			String path = tmpFolder.getAbsolutePath() + File.separator +  links.get(report);
			try {
				File file = new File(path);
				file.getParentFile().mkdirs();
				file.createNewFile();
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(report.getDoc().toString().getBytes());
				fos.close();
			}catch (Exception e) {
				System.out.println("failed to write element report");
				continue;
			}
		}
	}

	@Override
	public void loadTemplate() {
		loadTemplateFile(this.template_path);
	}

	public ProjectCoupe getProjectCoupe() {
		return projectCoupe;
	}

	public void setProjectCoupe(ProjectCoupe projectCoupe) {
		this.projectCoupe = projectCoupe;
	}

	public String getReportDir() {
		return reportDir;
	}

	public void setReportDir(String reportDir) {
		this.reportDir = reportDir;
	}
	
	

	
	
}
