package gdxapp.screens.room3d;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

import com.badlogic.gdx.math.Vector3;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.mathutils.Vector4;
import dressing.model.Containment;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;

public class ContainmentManager {
	
	private ArrayList<Containment> containments;
	private boolean initialized;
	private static ContainmentManager manager = new ContainmentManager();
	
	
	private ContainmentManager() {}
	
	//for testing purposes
	public void init() throws IOException {
		if(!initialized) {
			loadContainments();
			initialized = true;
		}

	}
	
	public void loadContainments() {
		File file = new File(WorkspaceConfiguration.CONTAINMENTS);
		if(file.exists()) {
			try {
				FileInputStream fis = new FileInputStream(file);
				Object[] containmentsArray = MapperProvider.getXmlMapper().fromXml(fis, Containment[].class);
				containments = new ArrayList<Containment>();
				for(Object element: containmentsArray) {
					containments.add((Containment) element);
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.err.println("failed to read containments relation from file!");
				containments = new ArrayList<Containment>();
			} 
		}
	}
	
	public ArrayList<WorldObject> applyContainment(Containment containment) {
		ArrayList<WorldObject> includedObjects = new ArrayList<WorldObject>();
		ArrayList<KitchenElement> containers = ProjectManager.getManager().getCurrentScene().getWorldObjectByModelUUID(containment.getContainerUUID());
		for(KitchenElement container: containers) {
			WorldObject contained = ModelProvider.getWorldObjectById(containment.getContainedUUID());
			if(contained != null) {
				if(!containment.isFixedSize()) {
					Vector4 dimension = contained.getRealWorldDimension();
					dimension.x = (float) container.getDesignObject().getLongeurint()/1000;
					dimension.z = (float) container.getDesignObject().getProfondeurint()/1000;
					contained.setRealWorldDimension(dimension);
				}
				contained.setRealWorldPosition(container.getRealWorldPosition().cpy().add(containment.getRelativePosition()));
				contained.setRotation(container.getRotation());
				includedObjects.add(contained);
			}
		}
		return includedObjects;
	}
	
	public ArrayList<WorldObject> execute(){
		ArrayList<WorldObject> implicitObjects = new ArrayList<WorldObject>();
		if(containments != null) {
			for(Containment containment: this.containments) {
				ArrayList<WorldObject> implicitObject = applyContainment(containment);
				implicitObjects.addAll(implicitObject);
			}
		}
		return implicitObjects;
	}

	public static ContainmentManager getManager() {
		return manager;
	}

	public static void setManager(ContainmentManager manager) {
		ContainmentManager.manager = manager;
	}

	
	
	
}
