package dressing.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.config.WorkspaceConfiguration;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.assets.AssetsTextures;
import gdxapp.shaders.PbrMaterial;
import param.Material;
import param.MaterialType;
import param.impl.MaterialImpl;


public class SingleImageItemLabelProvider extends LabelProvider implements ITableLabelProvider {

	Composite parent;
		
	public SingleImageItemLabelProvider() {
		super();
	}

	public SingleImageItemLabelProvider(Composite parent) {
		super();
		this.parent = parent;
	}

	public Image getColumnImage(Object element, int columnIndex) {
		String path="";
		if(element instanceof Materiaux) {
			Materiaux item = (Materiaux) element;
			if (columnIndex == 0) {
				if (item != null && item.getMotif() != null) {
					path = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + item.getMotif();
				}
			}
		}
		if(element instanceof MaterialImpl) {
			MaterialImpl item = (MaterialImpl) element;
			if (columnIndex == 0) {
				if (item != null && item.getImage() != null) {
					path = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + item.getImage();
				}
			}
			path=null;
		}
		else if(element instanceof SceneTexture ) {
			SceneTexture texture = (SceneTexture) element;
				if (texture != null && texture.getPath() != null) 
					{
						path = texture.getPath();
					}	
		}else if (element instanceof PbrMaterial) {
			PbrMaterial mtl = (PbrMaterial) element;
			path =  mtl.getAlbedoMapPath();
		}
		
		if (path != null && !path.isEmpty() && parent != null) {
			try {
				SceneTexture sceneTexture  = ModelProvider.getTexture(path);
				if(sceneTexture != null)
					return sceneTexture.getLabelImage();
				
			} catch (Exception e) {
				System.err.println("failed to get image label " + path);
				e.printStackTrace();
				return null;
			}
		}
		return null;
	}



	public String getPbrMaterialImageLabelPath(PbrMaterial element) {
		String albedoFileName = element.getAlbedoMapPath();
		String path = albedoFileName;
		if(albedoFileName != null) {
			File file = new File(albedoFileName);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists()) {
					path = file.getAbsolutePath();
				}
			}
		}else {
			path = element.getNormalMapPath();
			if(path == null)
				return null;
			File file = new File(path);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists())
					path = altPath;
			}
		}
		return path;
	}

	public String getColumnText(Object element, int columnIndex) {
		if(element instanceof Materiaux) {
			Materiaux item = (Materiaux) element;
			switch (columnIndex) {
			case 0:
				return item.getName();
			case 1:
				return String.valueOf(item.getEpaisseur());	
			}
		}else if(element instanceof Material) {
			Material item = (Material) element;
			switch (columnIndex) {
			case 0:
				return item.getName();
			case 1:
				return String.valueOf(item.getEpaisseur());
			}
		}else if(element instanceof SceneTexture) {
			SceneTexture item = (SceneTexture) element;
			Path path = new Path(item.getPath());
			return path.lastSegment();
		}else if(element instanceof MaterialType) {
			MaterialType item = (MaterialType) element;
			return item.getName();
		}
		return element.toString();
	}
	

}
