package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Edge;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeCommandController;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Preferences;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.WallFragment;
import geometry.CompoundShape;
import geometry.Polygon;
import param.MechanicDesign;
import param.MechanicPublicParam;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;

public class EdgeMesureWidow extends org.eclipse.jface.window.Window{

	public EdgeMesureWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}
	public Shell shell;
	public Action runAction;
	private Wall wall;
	private Edge edge;
	private Spinner spnLength, spnHeight, spnThickness;
	ArrayList<Edge> edges;
	Polygon polygon;
	CompoundShape compoundShape;
	boolean isFirstEdge;
	boolean isLastEdge;
	int index;
	
	Listener controlListener=new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			CommandStack command=updateObject();
			
		}
	};
	Listener KeyUpListener= new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			if(event.keyCode==SWT.CR) {
				CommandStack command=updateObject();
				if(command!=null)
				{
					if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
					{
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
					}

				}
			}
			
		}
	};
	private static EdgeMesureWidow instance;

	public static EdgeMesureWidow getInstance() {
	 		synchronized(EdgeMesureWidow.class) {
	 			if (instance == null) {
	 				instance = new EdgeMesureWidow(GdxPart.parentShell);
	 				instance.create();
	 				instance.constrainShellSize();
	 			}
	 			return instance;
	 		}
	 }
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			Shell shell=new Shell();

			EdgeMesureWidow window = new EdgeMesureWidow(shell);
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public Action getRunAction() {
		return runAction;
	}

	public void setRunAction(Action runAction) {
		this.runAction = runAction;
	}

	

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}
	

	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 289;
		gd_composite_1.heightHint = 171;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(2, false));
		
		Label lblLongeur = new Label(composite_1, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");
		
		spnLength = new Spinner(composite_1, SWT.BORDER);
		GridData gd_spnLength = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spnLength.widthHint = 173;
		spnLength.setLayoutData(gd_spnLength);
		spnLength.setMaximum(100000000);
		
		Label lblHauteur = new Label(composite_1, SWT.NONE);
		lblHauteur.setText("Hauteur");
		
		spnHeight = new Spinner(composite_1, SWT.BORDER);
		spnHeight.setMaximum(10000);
		spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblEpaisseur = new Label(composite_1, SWT.NONE);
		lblEpaisseur.setText("Epaisseur");
		
		spnThickness = new Spinner(composite_1, SWT.BORDER);
		spnThickness.setMaximum(10000);
		spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_2.heightHint = 39;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);
		
		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		if(runAction !=null) {
			btnRun.setText(runAction.getText());
		}else {
			btnRun.setText("Terminer");
		}
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite.setTabList(new Control[]{composite_1, composite_2});
		
				btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						EdgeMesureWidow.this.hide();
					}
					
				});
				btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						float l=EdgeMesureWidow.this.spnLength.getSelection();
						l /= 1000;
						l *= RoomController.getInstance().getScaleX();
						
						float h=EdgeMesureWidow.this.spnHeight.getSelection();
						h /= 1000;
						
						float t=EdgeMesureWidow.this.spnThickness.getSelection();
						t /= 1000;
						
						Material material = AssetsTextures.getInstance().getMaterial("Wall");
						
						//implent update logic here
						if(!isFirstEdge && !isLastEdge) {
							if(edges != null) {
								Vector2 translation = edge.getDirector().nor().scl(l-edge.getLength());
								for(int i = index + 1; i < edges.size(); i++) {
									edges.get(i).getV0().add(translation);
									if(i == edges.size() - 1)
										edges.get(i).getV1().add(translation);
								}
							}
						}else {
							int mode = 1;
							if(isFirstEdge)
								mode = -1;
							edge.setLength(l, mode);
						}
						ProjectManager.getManager().getCurrentScene().insertWallFragment(edge, h, t, material);
						hide();
					}
					
				});
		return composite;

	}
	
	public Edge getEdge() {
		return edge;
		
	}
	public void setEdge(Edge edge) {
		this.edge = edge;
		if(edge!=null)
		{
			float l=this.edge.getLength();
			this.spnLength.setSelection((int)((l*1000)/ RoomController.getInstance().getScaleX()));
			WallFragment fragment = ProjectManager.getManager().getCurrentScene().getFragments().get(edge);
			if(fragment != null) {
				this.spnHeight.setSelection((int)(fragment.getHeight() * 1000));
				this.spnThickness.setSelection((int)(fragment.getThickness() * 1000));
			}else {
				this.spnHeight.setSelection((int)(Preferences.WALL_HEIGHT * 1000));
				this.spnThickness.setSelection((int)(Preferences.WALL_WIDTH * 1000));
			}
			isFirstEdge = false;
			isLastEdge = false;
			this.edges = null;
		}
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			EdgeMesureWidow.this.shell.setVisible(true);
			EdgeMesureWidow.this.shell.setActive();

		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			EdgeMesureWidow.this.shell.setVisible(false);
		}

	}
	public CommandStack updateObject(){
		
		return null;
	}
	public void createController() {
		
	}
	public Polygon getPolygon() {
		return polygon;
	}
	public void setPolygon(Polygon polygon) {
		this.polygon = polygon;
	}
	public CompoundShape getCompoundShape() {
		return compoundShape;
	}
	
	public void setCompoundShape(CompoundShape compoundShape) {
		this.compoundShape = compoundShape;
		index = -1;
		for(int i = 0; i < compoundShape.getEdges().size(); i++) {
			if(compoundShape.getEdges().get(i).equals(this.edge)) {
				index = i;
				break;
			}
		}
		if(index == 0) {
			isFirstEdge = true;
		}
		if(index == compoundShape.getEdges().size() -1) {
			isLastEdge = true;
		}	
	}
	
	public ArrayList<Edge> getEdges() {
		return edges;
	}
	
	public void setEdges(ArrayList<Edge> edges) {
		this.edges = edges;
		index = -1;
		for(int i = 0; i < edges.size(); i++) {
			if(edges.get(i).equals(this.edge)) {
				index = i;
				break;
			}
		}
		if(index == 0) {
			isFirstEdge = true;
		}
		if(index == edges.size() -1) {
			isLastEdge = true;
		}
	}
	
	
	
	
	
	
}
