package dressing.ui.tiroire;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.TiroireCreator;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.etagere.EtagereWizardSecondPage;
import dressing.ui.etagere.EtagereWizardWelcomePage;

public class TiroireWizard extends Wizard{
	@Inject
	IEclipseContext eclipsecontext;

	@Inject
	private EHandlerService handlerService;

	
	@Inject
	private ECommandService commandService;

	Space3D space3d;
	TiroireCreator tCreator=new TiroireCreator();
	TiroireWizardWelcomePage welcomePage;
	/**
	 * @return the tCreator
	 */
	public TiroireCreator gettCreator() {
		return tCreator;
	}
	/**
	 * @param tCreator the tCreator to set
	 */
	public void settCreator(TiroireCreator tCreator) {
		this.tCreator = tCreator;
	}
	/**
	 * @return the space3d
	 */
	public Space3D getSpace3d() {
		return space3d;
	}
	/**
	 * @param space3d the space3d to set
	 */
	public void setSpace3d(Space3D space3d) {
		this.space3d = space3d;
		this.tCreator.setParent(space3d);
	}
	@Override
	public void addPages() {
		 welcomePage=new TiroireWizardWelcomePage("Welcome Page", this.tCreator);
		addPage(welcomePage);
	}
	@Override
	public boolean performFinish() {
		for (IWizardPage page : getPages()) {
			((WizardPage) page).setErrorMessage("");
		}
	try {
			
			
			this.tCreator.create();
			welcomePage.clearlistners();
			
			
			List<DesignObject3D> tirroirlist = tCreator.getTiroirList();
			for (DesignObject3D tiroir : tirroirlist) {
				space3d.addElement(tiroir);
			}
		} catch (DesignException | GeometricEngineException e) {
			for (IWizardPage page : getPages()) {
				((WizardPage) page).setErrorMessage(e.getMessage());
			}
			return false;
		}
		return true;

	}
	@Override
	public boolean canFinish() {
		if (!welcomePage.isPageComplete())
			return false;
		
		return true;
	}
	
}
