package dressing.ui.project;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import gdxapp.scenes.SceneEvent;
import geometry.ShapeDrawer;
import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.handlers.gdx.ToolControlHandler;
import dressing.ui.shapedrawer.FinalPage;

public class CreateFormWizard extends Wizard implements EventHandler {

	private IWizardPage currentPage;
	private FloorConfigWizardFormPage floorPage;
	private MarbreConfigWizardFormPage MarbrePage;
	private WallConfigWizardFormPage wallPage;
	private CreateFormPage formPage;
	private SocleWizardPage soclepage;


	
	public CreateFormPage getFormPage() {
		return formPage;
	}

	public CreateFormWizard() {
		setWindowTitle("Création d'un objet");		
		subscribe(SceneEvent.CREATE_OBJECT_CMD.name());
	}

	@Override
	public void addPages() {
		formPage = new CreateFormPage();
		wallPage = new WallConfigWizardFormPage();
		floorPage = new FloorConfigWizardFormPage();
		soclepage = new SocleWizardPage();
		MarbrePage = new MarbreConfigWizardFormPage("");
		addPage(formPage);
		addPage(wallPage);
		addPage(floorPage);
		addPage(soclepage);
		addPage(MarbrePage);
		currentPage = getStartingPage();
	}


	@Override
	public boolean performFinish() {
		FinalPage page = (FinalPage) currentPage;
		page.onHide();
		ToolControlHandler.getInstance().triggerSelectObject();
		return true;
	}

	public FloorConfigWizardFormPage getFloorPage() {
		return floorPage;
	}

	public void setFloorPage(FloorConfigWizardFormPage floorPage) {
		this.floorPage = floorPage;
	}

	public WallConfigWizardFormPage getWallPage() {
		return wallPage;
	}

	public MarbreConfigWizardFormPage getMarbrePage() {
		return MarbrePage;
	}

	public void setMarbrePage(MarbreConfigWizardFormPage marbrePage) {
		MarbrePage = marbrePage;
	}

	public void setWallPage(WallConfigWizardFormPage wallPage) {
		this.wallPage = wallPage;
	}

	public SocleWizardPage getSoclepage() {
		return soclepage;
	}

	public void setSoclepage(SocleWizardPage soclepage) {
		this.soclepage = soclepage;
	}

	@Override
	public boolean canFinish() {

		return wallPage.isPageComplete() || floorPage.isPageComplete() || soclepage.isPageComplete()
				|| MarbrePage.isPageComplete()|| formPage.isPageComplete();
	}

	public void setCurrentPage(IWizardPage page) {
		currentPage = page;
		((FinalPage)currentPage).onDisplay();
		getContainer().updateButtons();
	}
	
	
	
	@Override
	public boolean performCancel() {
		ShapeDrawer.getInstance().finish();
		dispose();
		return true;
	}


		
		
	

	@Override
	public void dispose() {
		super.dispose();
		unsubscribe();
	}

	private void createObjectSelected(String type) {
		WizardPage page = null;
		switch (type) {
		case "WALL": 
			page = wallPage;
			break;
			case "FLOOR":
				page = floorPage;
				break;
			case "MARBLE":
				page = MarbrePage;
				break;
			case "PLINTH":
				page = soclepage;
				break;
		default:
			throw new IllegalArgumentException("Unexpected value: " + type);
	}
		
		
		if(page != null) {
			displayPage(page);
		}
		
	}

	private void displayPage(WizardPage page) {
		try {
			setCurrentPage(page);
			getContainer().showPage(page);
		}catch (NullPointerException e) {
			System.err.println("error");
		}
	}

	@Override
	public void handle(Event event) {
		SceneEvent eventTopic = SceneEvent.valueOf(event.getTopic());
		
		switch (eventTopic){
		case CREATE_OBJECT_CMD: {
			createObjectSelected(event.getData().toString());
			break;
		}
		default:
			throw new IllegalArgumentException("Unexpected value: " + eventTopic);
		}
	}

}
