package dressing.ui.modelprovders;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.model.types.PieceType;
import dressing.model.types.Zone3DType;
import dressing.ui.parts.ProjectTreePart;

public class NameLabelProvider extends LabelProvider implements IStyledLabelProvider {
	public  Display display;
	
	
    public NameLabelProvider() {
		super();
	}

	public NameLabelProvider(Display display) {
		super();
		this.display = display;
	}

	@Override
    public StyledString getStyledText(Object element) {
    	if(element!=null && element instanceof Caisson)
    	{       
    			Caisson piece = (Caisson) element;
        		// a directory is just a container and has no size
    			Styler namestyle  = new Styler() {
					
					@Override
					public void applyStyles(TextStyle textStyle) {
						// TODO Auto-generated method stub
						if(piece.isErrorexist())
						{
							textStyle.background = display.getSystemColor(SWT.COLOR_RED);
						}
					}
				};
    			StyledString stytl = new StyledString(""+piece.getName(),namestyle);
    			
    			Styler dimstyle = new Styler() {
					
					@Override
					public void applyStyles(TextStyle textStyle) {
						// TODO Auto-generated method stub
						textStyle.foreground = display.getSystemColor(SWT.COLOR_BLUE);
					}
				};
    			stytl.append(" ["+piece.getLongeurext()+"]", dimstyle);
        		return stytl;
    		
    	}
    	else if(element!=null && element instanceof Cuisine) {
    		Dressing piece = (Dressing) element;
    		// a directory is just a container and has no size
    		// a directory is just a container and has no size
			Styler namestyle  = new Styler() {
				
				@Override
				public void applyStyles(TextStyle textStyle) {
					// TODO Auto-generated method stub
					if(piece.isErrorexist())
					{
						textStyle.background = display.getSystemColor(SWT.COLOR_RED);
					}
					
				}
			};
			StyledString stytl = new StyledString(""+piece.getName(),namestyle);
			Styler dimstyle = new Styler() {
				
				@Override
				public void applyStyles(TextStyle textStyle) {
					// TODO Auto-generated method stub
					textStyle.foreground = display.getSystemColor(SWT.COLOR_BLUE);
				}
			};
			stytl.append(" ["+piece.getHauteurext()+" , "+piece.getProfondeurext()+"]", dimstyle);
    		return stytl;
    	}
    	else if(element!=null && element instanceof Dressing)
    	{
    		Dressing piece = (Dressing) element;
    		// a directory is just a container and has no size
    		// a directory is just a container and has no size
			Styler namestyle  = new Styler() {
				
				@Override
				public void applyStyles(TextStyle textStyle) {
					// TODO Auto-generated method stub
					if(piece.isErrorexist())
					{
						textStyle.background = display.getSystemColor(SWT.COLOR_RED);
					}
					
				}
			};
			StyledString stytl = new StyledString(""+piece.getName(),namestyle);
			Styler dimstyle = new Styler() {
				
				@Override
				public void applyStyles(TextStyle textStyle) {
					// TODO Auto-generated method stub
					textStyle.foreground = display.getSystemColor(SWT.COLOR_BLUE);
				}
			};
			stytl.append(" ["+piece.getLongeurext()+" , "+piece.getHauteurext()+" , "+piece.getProfondeurext()+"]", dimstyle);
    		return stytl;
    	}
    	
    	else if (element!=null && element instanceof DesignObject3D) {
        	DesignObject3D piece = (DesignObject3D) element;

                // a directory is just a container and has no size
                return new StyledString(""+piece.getName());
        }
        return new StyledString(" ");
    }

	@Override
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		String s =null;
		if(element instanceof CaissonCuisine||element instanceof Space3DFree){
			s="icons/caissoncuisine.png";
		}
		else if (element instanceof Caisson) {
			s= "icons/caissonIcon16.png";
		}else if(element instanceof Cuisine){
			s="icons/icon-cuisine.png";
		}
		else if(element instanceof Dressing)
		{
			s="icons/dressing.png";
		}else if(element instanceof Etagere) {
			s="icons/etagereIcon16.png";
		}else if(element instanceof Tirroir) {
			s="icons/tiroirIcon16.png";
		}
		else if(element instanceof Separator) {
			s="icons/seperateur16.png";
		}
		
		else if(element instanceof Piece2D)
		{
			Piece2D piece=(Piece2D)element;
			if(piece.getPiecetype().equals(PieceType.PORTE)) {
				s="icons/singleporteIcon.png";
			}else if(piece.getPiecetype().equals(PieceType.PORTE_DROITE)||piece.getPiecetype().equals(PieceType.PORTE_GAUCHE)
					||piece.getPiecetype().equals(PieceType.PORTE_HAUT)||piece.getPiecetype().equals(PieceType.PORTE_BAS)) {
				s="icons/porte16.png";
			}
			else if(piece.getPiecetype().equals(PieceType.HAUT_CUISSON)) {
				s="icons/hautIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.BAS_CUISSON)||piece.getPiecetype().equals(PieceType.BAS_TIROIR)) {
				s="icons/basIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.DROITE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_DROITE_TIROIR)) {
				s="icons/droiteIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.GAUCHE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_GAUCHE_TIROIR)) {
				s="icons/gaucheIcon16.png";
			}
			
			else  {
				s="icons/piece16.jpg";
			}
			
		
		}else if(element instanceof Space3D )
		{
			Space3D space=(Space3D)element;
			if(space.getZonetype().equals(Zone3DType.ZONEHAUT)) {
				s="icons/zonehautIcon16.png";
			}else if(space.getZonetype().equals(Zone3DType.ZONEBAS)) {
				s="icons/zonebasIcon16.png";
			}
			
		}
		else if(element instanceof Project3D)
		{
			s="icons/project3d.png";
		}
		if(s !=null)
		{
			Bundle bundle = FrameworkUtil.getBundle(NameLabelProvider.class);
			URL url = FileLocator.find(bundle, new Path(s), null);
			ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
			ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
			Image im = rsmanager.createImage(descriptor);

			return im;
		}

		return super.getImage(element);
	}

	
}