package dressing.ui.editorWindows;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.model.ModelProvider;
import dressing.ui.util.ImageLoaderCache;
import param.Accessoire;
import param.AccessoireInstance;
import param.Article;
import param.ArticleFamily;
import param.ArticleFamilyGroup;
import param.ArticleInstance;
import param.BaseObject;
import param.ParamFactory;
import param.Quincaillerie;
import param.QuincaillerieInstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import dressing.ui.DoubleTextFieldFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;

public class ArticleInstanceEditorWindow extends EditorWindow {
	private DataBindingContext m_bindingContext;

	private ScrolledComposite container;
	private Composite root;

	private Text txtName;
	private Text txtNumber;
	private Text txtPrice;
	String errorMessage="";

	private ArticleInstance articleInstance;
	private ArticleInstance articleInstanceOrigin;

	private Composite composite;

	private ComboViewer comboViewerArticle;
	private Label lblImage;
	private Button btnModifiable;
	private Button btnStandAlone;
	private Label lblFamilleArticle;
	private Combo comboFamilleArticle;
	private ComboViewer comboViewerFamilleArticle;
	private Button btnAfficherDevis;
	public ArticleInstanceEditorWindow(Shell parentShell,int update,ArticleInstance article) {
		super(parentShell,update);
		this.articleInstance = article;
		this.articleInstanceOrigin=EcoreUtil.copy(article);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		container = new ScrolledComposite(parent, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		root = new Composite(container, SWT.NONE);
		root.setLayout(new GridLayout(3, false));
		
		composite = new Composite(root, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		GridData gd_composite = new GridData(SWT.LEFT, SWT.FILL, false, true, 1, 8);
		gd_composite.heightHint = 150;
		gd_composite.minimumWidth = 200;
		gd_composite.minimumHeight = 200;
		gd_composite.widthHint = 200;
		composite.setLayoutData(gd_composite);
		
		lblImage = new Label(composite, SWT.NONE);
		
		lblFamilleArticle = new Label(root, SWT.NONE);
		lblFamilleArticle.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblFamilleArticle.setText("Famille Article");
		
		comboViewerFamilleArticle = new ComboViewer(root, SWT.READ_ONLY);
		comboFamilleArticle = comboViewerFamilleArticle.getCombo();
		comboFamilleArticle.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		
		Label lblArticle = new Label(root, SWT.NONE);
		lblArticle.setText("Article");
		
		comboViewerArticle = new ComboViewer(root, SWT.READ_ONLY);
		Combo comboArticle = comboViewerArticle.getCombo();
		comboArticle.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		
		Label lblNom = new Label(root, SWT.NONE);
		lblNom.setText("Nom");
		
		txtName = new Text(root, SWT.BORDER);
		txtName.setEditable(false);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNumber = new Label(root, SWT.NONE);
		lblNumber.setText("Nombre");
		
		txtNumber =DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
		txtNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblPrice = new Label(root, SWT.NONE);
		lblPrice.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblPrice.setText("Prix");
		
		txtPrice = DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
		txtPrice.setEditable(false);
		txtPrice.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		btnModifiable = new Button(root, SWT.CHECK);
		btnModifiable.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 2, 1));
		btnModifiable.setText("Modifiable");
		
		btnStandAlone = new Button(root, SWT.CHECK);
		btnStandAlone.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 2, 1));
		btnStandAlone.setText("Calcule Séparer");
		
		btnAfficherDevis = new Button(root, SWT.CHECK);
		btnAfficherDevis.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		btnAfficherDevis.setText("Afficher Devis");
		new Label(root, SWT.NONE);

		container.setContent(root);
		container.setMinSize(root.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		Point preferedSize = container.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		int frameX = shell.getSize().x - shell.getClientArea().width;
		int frameY = shell.getSize().y - shell.getClientArea().height;
		shell.setSize(preferedSize.x + frameX + 50, preferedSize.y + frameY + 50);
		shell.setLocation((shell.getParent().getSize().x - shell.getSize().x) / 2 + shell.getParent().getLocation().x,
				(shell.getParent().getSize().y - shell.getSize().y) / 2 + shell.getParent().getLocation().y);
		
		String titleWindow = "d'Accessoire";
		if(this.articleInstance instanceof AccessoireInstance) {
			titleWindow="Accessoire";
		}
		if(this.articleInstance instanceof QuincaillerieInstance) {
			titleWindow="du Quincaillerie";
		}
		this.shell.setText("Editeur " + titleWindow);

		m_bindingContext = initspecialDataBindings();
		addControl();
		if(getUpdateMode()==EditorWindow.update || getUpdateMode()==EditorWindow.View) {
			Article article=null;
			if(this.articleInstance instanceof AccessoireInstance) {
				article=((AccessoireInstance) this.articleInstance).getAccessoire();
			}
			if(this.articleInstance instanceof QuincaillerieInstance) {
				article=((QuincaillerieInstance) this.articleInstance).getQuincaillerie();
			}
			if(article!=null)
			{
				comboViewerArticle.setSelection(new StructuredSelection(article));
				if(article.getImage().getPath()!=null && !article.getImage().getPath().isEmpty()) {
					lblImage.setImage(ImageLoaderCache.getInstance().loadImage(article.getImage().getPath(), 200, 200));
				}
				String price= String.valueOf( ( article.getPrix()*articleInstance.getNombreFix() ) );
				txtPrice.setText(price);
			}
			
		}

		return container;
	}
	public void addControl() {
		comboViewerArticle.setLabelProvider(new LabelProvider() {
			
			@Override
			public String getText(Object element) {
				if(element instanceof Article) {
					Article article =(Article)element;
					String name=article.getName();
					
					return name;
				}
				
				return super.getText(element);
			}
		});
		comboViewerArticle.setContentProvider(new ArticleInstanceContentProvider(articleInstance instanceof AccessoireInstance));
		if(articleInstance.getFixedFamily()!=null ) {
			comboViewerArticle.setInput(articleInstance.getFixedFamily());
		}else if(articleInstance instanceof AccessoireInstance) {
			comboViewerArticle.setInput(ModelProvider.getModelroot().getAccesoires().getAccessoires());
		}else {
			comboViewerArticle.setInput(ModelProvider.getModelroot().getQuincailleries().getQuincailleries());
		}
		comboViewerArticle.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection=comboViewerArticle.getStructuredSelection().getFirstElement();
				if(selection !=null) {
					if(selection instanceof Article) {
						Article acc=(Article)selection;
						if(acc!=null)
						{
							if(acc.getImage().getPath()!=null && !acc.getImage().getPath().isEmpty()) {
								lblImage.setImage(ImageLoaderCache.getInstance().loadImage(acc.getImage().getPath(), 200, 200));
							}
							txtName.setText(acc.getName());
						}
						
					}
				}
				refreshPrice();
				
			}
		});
		txtNumber.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				refreshPrice();
			}
		});
		txtPrice.setText("0.000");
		comboViewerFamilleArticle.setLabelProvider(new LabelProvider() {
			
			@Override
			public String getText(Object element) {
				if(element instanceof ArticleFamily) {
					ArticleFamily family =(ArticleFamily)element;
					String name=family.getName();
					while(family.getParentFamily()!=null) {
						
						family =family.getParentFamily();
						 name=family.getName()+"\\"+name;
					}
					return name;
				}else {
					return "";
				}
				
			}
		});
		comboViewerFamilleArticle.setContentProvider(new IStructuredContentProvider() {
			
			@Override
			public Object[] getElements(Object inputElement) {
				List<Object> families = new ArrayList<Object>();
				families.add(new Object());
				if (inputElement instanceof ArticleFamilyGroup) {
					ArticleFamilyGroup familyGroup = (ArticleFamilyGroup) inputElement;
					for (ArticleFamily family : familyGroup.getFamilles()) {
						families.add(family);
						getfamilies(family, families);
					}
				}
				return families.toArray();
			}

			private void getfamilies(ArticleFamily family,List<Object> families) {
				for(ArticleFamily subfamily:family.getFamilies()) {
					families.add(subfamily);
					getfamilies(subfamily,families);
				}
			}
		});
		comboViewerFamilleArticle.setInput(ModelProvider.getModelroot().getArticleFamilies());
		comboViewerFamilleArticle.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection=comboViewerFamilleArticle.getStructuredSelection().getFirstElement();
				if(selection !=null && selection instanceof ArticleFamily) {
					comboViewerArticle.setInput((ArticleFamily)selection);
				}
				
			}
		});
	}
	private void refreshPrice() {
		Object selection=comboViewerArticle.getStructuredSelection().getFirstElement();
		String price="0.0";
		if(selection !=null) {
			if(selection instanceof Article) {
				Article acc=(Article)selection;
				if(acc!=null)
				{
					price= String.valueOf( ( acc.getPrix()*articleInstance.getNombreFix() ) );
					txtPrice.setText(price);
				}
				
			}
		}
	}
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		if(this.articleInstance instanceof AccessoireInstance) {
			((AccessoireInstance) this.articleInstance).setAccessoire((Accessoire) comboViewerArticle.getStructuredSelection().getFirstElement());
		}
		if(this.articleInstance instanceof QuincaillerieInstance) {
			((QuincaillerieInstance) this.articleInstance).setQuincaillerie((Quincaillerie) comboViewerArticle.getStructuredSelection().getFirstElement());
		}
		Object selection=comboViewerFamilleArticle.getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof ArticleFamily) {
			this.articleInstance.setFixedFamily((ArticleFamily) selection);
		}
		
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String numberS=txtNumber.getText();
		try {
			Double numberD =Double.valueOf(numberS);
			if(numberD<=0) {
				errorExist=true;
				errorMessage="Le prix doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="Le prix est obligatoire";
		}
		Object article = comboViewerArticle.getStructuredSelection().getFirstElement();
		if(article==null || !(article instanceof Article)){
			errorExist=true;
			errorMessage="L'Article est obligatoire";
		}
		return !errorExist;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {
		this.articleInstance.setName(this.articleInstanceOrigin.getName());
		this.articleInstance.setNombreFix(this.articleInstanceOrigin.getNombreFix());
	}
	protected DataBindingContext initspecialDataBindings() {
		DataBindingContext bindingContext = initDataBindings();

		//
		IObservableValue observeSelectionBtnModifiableObserveWidget = WidgetProperties.buttonSelection().observe(btnModifiable);
		IObservableValue changeableArticleInstanceObserveValue = BeanProperties.value("changeable").observe(articleInstance);
		bindingContext.bindValue(observeSelectionBtnModifiableObserveWidget, changeableArticleInstanceObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnStandAloneObserveWidget = WidgetProperties.buttonSelection().observe(btnStandAlone);
		IObservableValue standAloneArticleInstanceObserveValue = BeanProperties.value("standAlone").observe(articleInstance);
		bindingContext.bindValue(observeSelectionBtnStandAloneObserveWidget, standAloneArticleInstanceObserveValue, null, null);
		//
		IObservableValue observeSelectionbtnbtnAfficherDevisObserveWidget = WidgetProperties.buttonSelection().observe(btnAfficherDevis);
		IObservableValue showReportArticleInstanceObserveValue = BeanProperties.value("showReport").observe(articleInstance);
		bindingContext.bindValue(observeSelectionbtnbtnAfficherDevisObserveWidget, showReportArticleInstanceObserveValue, null, null);
		//

		return bindingContext;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameAccessoireObserveValue = BeanProperties.value("name").observe(articleInstance);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtNumberObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtNumber);
		IObservableValue nombreFixArticleObserveValue = BeanProperties.value("nombreFix").observe(articleInstance);
		bindingContext.bindValue(observeTextTxtNumberObserveWidget, nombreFixArticleObserveValue, null, null);
		//
		return bindingContext;
	}
}
class ArticleInstanceContentProvider implements IStructuredContentProvider {

	private boolean isAccessoire=true;
	public ArticleInstanceContentProvider(boolean isAccessoire) {
		this.isAccessoire=isAccessoire;
	}
	
	/**
	 * Returns the elements in the input, which must be either an array or a
	 * <code>Collection</code>.
	 */
	@Override
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof Object[]) {
			return (Object[]) inputElement;
		}
		if (inputElement instanceof Collection) {
			return ((Collection) inputElement).toArray();
		}
		ArrayList<BaseObject> articles=new ArrayList<BaseObject>();
		if(inputElement instanceof ArticleFamily) {
			getArticles((ArticleFamily)inputElement, articles);
			return articles.toArray();
		}
		if(inputElement instanceof ArticleFamilyGroup) {
			if(((ArticleFamilyGroup)inputElement).getFamilles()!=null && ((ArticleFamilyGroup)inputElement).getFamilles().size()>0) {
				for(ArticleFamily sub_family:((ArticleFamilyGroup)inputElement).getFamilles()) {
					getArticles(sub_family, articles);
				}
			}
			return articles.toArray();

		}		
		return new Object[0];
	}
	public void getArticles(ArticleFamily family,ArrayList<BaseObject> articles) {
		if(family !=null && articles!=null) {
			if(isAccessoire&& family.getAccessoires()!=null && family.getAccessoires().size()>0) {
				articles.addAll(family.getAccessoires());
			}
			if(!isAccessoire && family.getQuincailleries()!=null && family.getQuincailleries().size()>0) {
				articles.addAll(family.getQuincailleries());
			}
			if(family.getFamilies()!=null && family.getFamilies().size()>0) {
				for(ArticleFamily sub_family:family.getFamilies()) {
					getArticles(sub_family, articles);
				}
			}
		}
	}
}