package dressing.ui.dressing;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;


import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PortType;
import dressing.ui.util.SingleImageItemLabelProvider;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import dressing.model.Materiaux;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DressingCompositeEditor extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private dressing.model.Dressing dressing =null; //new dressing.model.Dressing();
	private ModelProvider modelprovider = new ModelProvider();

	Text nameText;
	private Text etagetxt;
	private Text apptxt;
	private Label lblMatrieauxPrincipale;
	private Label lblMatrieauxDos;
	private Label lblTypeDePorte;
	private Combo combomatprincipale;
	//
	private TableComboViewer tableComboViewermatprincipale;
	//
	private ComboViewer comboViewermatprincipale;
	private Combo combomatdos;
	private ComboViewer comboViewer_matdos;
	//
	private TableComboViewer tableComboViewer_matdos;
	//
	private Combo combotypeporte;
	private ComboViewer comboViewer_2;
	private Label label;
	private Spinner spinnerlongeur;
	private Label label_1;
	private Spinner spinner_hauteur;
	private Label label_2;
	private Spinner spinner_profondeur;
	private Label lblNewLabel_1;
	private MDirtyable dirty;
	ControlDecoration deco;
	private StyledText styledText;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private TabFolder tabFolder;
	private TabItem tbtmAcceuil;
	private Composite composite;
	private Composite composite1;
	private TableComboViewer tcv;
	private TabItem tbtmMesure;
	private Label lblNewLabel_2;
	private Text text;
	public DressingCompositeEditor(Composite parent, int style, dressing.model.Dressing newDressing,int updatestrategy) {
		this(parent, style|SWT.V_SCROLL);
		this.updatestragey = updatestrategy;
		setDressing(newDressing);
	}

	public DressingCompositeEditor(Composite parent, int style) {
		super(parent, SWT.NONE);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		setLayout(new GridLayout(3, false));
		
		lblNewLabel_1 = new Label(this, SWT.NONE);
		lblNewLabel_1.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblNewLabel_1.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
		lblNewLabel_1.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.BOLD));
		lblNewLabel_1.setText("Dressing");
		
		styledText = new StyledText(this, SWT.BORDER);
		styledText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		styledText.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		styledText.setEditable(false);
		styledText.setDoubleClickEnabled(false);
		styledText.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		styledText.setAlwaysShowScrollBars(false);
		
		tabFolder = new TabFolder(this, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 3, 1));
		
		tbtmAcceuil = new TabItem(tabFolder, SWT.NONE);
		tbtmAcceuil.setText("Acceuil");
		
		composite = new Composite(tabFolder, SWT.NONE);
		
		tbtmAcceuil.setControl(composite);
		composite.setLayout(new GridLayout(2, false));
		
		Label label_4 = new Label(composite, SWT.NONE);
		label_4.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		label_4.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_4.setText("Nom");
						
		nameText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		nameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		nameText.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		//
		Label lblEtage = new Label(composite, SWT.NONE);
		lblEtage.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblEtage.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblEtage.setText("Etage");
								
		etagetxt = new Text(composite, SWT.BORDER);
		etagetxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		etagetxt.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));				
		Label lblapp = new Label(composite, SWT.NONE);
		lblapp.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblapp.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblapp.setText("Appartement");
								
		apptxt = new Text(composite, SWT.BORDER);
		apptxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		apptxt.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		//
														
		lblMatrieauxPrincipale = new Label(composite, SWT.NONE);
		lblMatrieauxPrincipale.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblMatrieauxPrincipale.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxPrincipale.setText("Mat\u00E9rieaux principale");
		//
		comboViewermatprincipale = new ComboViewer(composite, SWT.READ_ONLY);
		combomatprincipale = comboViewermatprincipale.getCombo();
		combomatprincipale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());
		comboViewermatprincipale.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewermatprincipale.setInput(ModelProvider.getMateriallist());
		//
//		tableComboViewermatprincipale = new TableComboViewer(composite, SWT.READ_ONLY | SWT.BORDER);
//		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
//		tableComboViewermatprincipale.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
//		tableComboViewermatprincipale.getTableCombo().setDisplayColumnIndex(0);		
//		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tableComboViewermatprincipale.getTableCombo().setEditable(false);
//		// set the content provider
//		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());
//		// set the label provider
//		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));
//		// load the data
//		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());					
		
		lblMatrieauxDos = new Label(composite, SWT.NONE);
		lblMatrieauxDos.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblMatrieauxDos.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxDos.setText("Mat\u00E9rieaux Dos");
//		tableComboViewer_matdos = new TableComboViewer(composite, SWT.READ_ONLY | SWT.BORDER);
//		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
//		tableComboViewer_matdos.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });
//		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
//		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tableComboViewer_matdos.getTableCombo().setEditable(false);
//		// set the content provider
//		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
//		
//		// set the label provider
//		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));
//
//		// load the data
//		tableComboViewer_matdos.setInput(ModelProvider.getMateriallist());	
		comboViewer_matdos = new ComboViewer(composite, SWT.READ_ONLY);
		combomatdos = comboViewer_matdos.getCombo();
		combomatdos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer_matdos.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer_matdos.setInput(ModelProvider.getMateriallist());
		//
		lblTypeDePorte = new Label(composite, SWT.NONE);
		lblTypeDePorte.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblTypeDePorte.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblTypeDePorte.setText("Type de porte");
		
		comboViewer_2 = new ComboViewer(composite, SWT.NONE);
		combotypeporte = comboViewer_2.getCombo();
		combotypeporte.setEnabled(false);
		combotypeporte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		combotypeporte.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		
		comboViewer_2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_2.setInput(PortType.values());
		
	
		
		tbtmMesure = new TabItem(tabFolder, SWT.NONE);
		tbtmMesure.setText("Mesure");
		
		lblNewLabel_2 = new Label(tabFolder, SWT.NONE);
		tbtmMesure.setControl(lblNewLabel_2);
		
		text = new Text(tabFolder, SWT.BORDER);
		tbtmMesure.setControl(text);
		lblNewLabel_2.setText("New Label");
		composite1 = new Composite(tabFolder, SWT.NONE);
		tbtmMesure.setControl(composite1);
		label = new Label(composite1, SWT.NONE);
		label.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		label.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label.setText("Longeur (mm)");
		
		spinnerlongeur = new Spinner(composite1, SWT.BORDER);
		spinnerlongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinnerlongeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinnerlongeur.setMaximum(1000000);
		
		label_1 = new Label(composite1, SWT.NONE);
		label_1.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		label_1.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_1.setText("Hauteur (mm)");
		
		spinner_hauteur = new Spinner(composite1, SWT.BORDER);
		spinner_hauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_hauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_hauteur.setMaximum(1000000);
		
		label_2 = new Label(composite1, SWT.NONE);
		label_2.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		label_2.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_2.setText("Profondeur (mm)");
		
		spinner_profondeur = new Spinner(composite1, SWT.BORDER);
		spinner_profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_profondeur.setMaximum(10000000);
		composite1.setLayout(new GridLayout(2, false));
		if(this.dressing!=null) {
			m_bindingContext = initDataBindings();
		}
		 
		//Ajouter le controle de dirty
		makedirtycontroller(this);
		makeerrorhandler(lblNewLabel_1);
		
		}
	

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.model.Dressing getDressing() {
		return dressing;
	}

	public void setDressing(dressing.model.Dressing newDressing) {
		setDressing(newDressing, true);
	}
public ModelProvider getModelprovider() {
	return modelprovider;
}
public void setModelprovider(ModelProvider modelprovider) {
	this.modelprovider = modelprovider;
}
	public void setDressing(dressing.model.Dressing newDressing, boolean update) {
		dressing = newDressing;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (dressing != null) {
				m_bindingContext = initDataBindings();
			}
//			//
//			FocusListener focus = new FocusListener() {
//				
//				@Override
//				public void focusLost(FocusEvent e) {
//					// TODO Auto-generated method stub
//					m_bindingContext.updateModels();
//				}
//				
//				@Override
//				public void focusGained(FocusEvent e) {
//					// TODO Auto-generated method stub
//					
//				}
//			};
//			spinner_hauteur.addFocusListener(focus);
//			spinner_profondeur.addFocusListener(focus);
//			spinnerlongeur.addFocusListener(focus);
		}
	}
	
	private DataBindingContext custominitDataBindings() {

		//
		return null;
	}
	
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller(Composite comp)
	{

		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = comp.getChildren();
				for(Control ctr : comp.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}

					if(ctr instanceof Composite)
					{
						makedirtycontroller((Composite)ctr);
					}
				}
	}

	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
		try
		{
			m_bindingContext.updateModels();

				dressing.update();

			deco.setDescriptionText("");
			deco.hide();
		}
		catch( Exception e)
		{
			deco.setDescriptionText(e.getMessage());
			deco.show();
		}

	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	protected void makeerrorhandler(Control control)
	{
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue nameObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(nameText);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(dressing);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
//		ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
//		IObservableMap observeMap_1 = BeansObservables.observeMap(listContentProvider_1.getKnownElements(), Materiaux.class, "name");
//		comboViewer_matdos.setLabelProvider(new ObservableMapLabelProvider(observeMap_1));
//		comboViewer_matdos.setContentProvider(listContentProvider_1);
//		//
//		IObservableList materiallistModelproviderObserveList = PojoProperties.list("materiallist").observe(modelprovider);
//		comboViewer_matdos.setInput(materiallistModelproviderObserveList);
		//
//		ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
//		IObservableMap observeMap = BeansObservables.observeMap(listContentProvider.getKnownElements(), Materiaux.class, "name");
//		comboViewermatprincipale.setLabelProvider(new ObservableMapLabelProvider(observeMap));
//		comboViewermatprincipale.setContentProvider(listContentProvider);
//		//
//		comboViewermatprincipale.setInput(materiallistModelproviderObserveList);
		//
		IObservableValue observeSingleSelectionComboViewermatprincipale = ViewerProperties.singleSelection().observe(comboViewermatprincipale);
		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewermatprincipale, basematerialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectionComboViewer_matdos = ViewerProperties.singleSelection().observe(comboViewer_matdos);
		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_matdos, backmaterialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
//		IObservableValue observeSingleSelectiontTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
//		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(dressing);
//		bindingContext.bindValue(observeSingleSelectiontTableComboViewermatprincipale, basematerialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
//		//
//		IObservableValue observeSingleSelectiontableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
//		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(dressing);
//		bindingContext.bindValue(observeSingleSelectiontableComboViewer_matdos, backmaterialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectionComboViewer_2 = ViewerProperties.singleSelection().observe(comboViewer_2);
		IObservableValue porttypeDressingObserveValue = BeanProperties.value("porttype").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_2, porttypeDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinnerObserveWidget = WidgetProperties.widgetSelection().observe(spinnerlongeur);
		IObservableValue longeurextDressingObserveValue = BeanProperties.value("longeurext").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinnerObserveWidget, longeurextDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_1ObserveWidget = WidgetProperties.widgetSelection().observe(spinner_hauteur);
		IObservableValue hauteurextDressingObserveValue = BeanProperties.value("hauteurext").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinner_1ObserveWidget, hauteurextDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_2ObserveWidget = WidgetProperties.widgetSelection().observe(spinner_profondeur);
		IObservableValue profondeurextDressingObserveValue = BeanProperties.value("profondeurext").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinner_2ObserveWidget, profondeurextDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeTextStyledTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(styledText);
		IObservableValue errormsgDressingObserveValue = BeanProperties.value("errormsg").observe(dressing);
		bindingContext.bindValue(observeTextStyledTextObserveWidget, errormsgDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleStyledTextObserveWidget = WidgetProperties.visible().observe(styledText);
		IObservableValue errorexistDressingObserveValue = BeanProperties.value("errorexist").observe(dressing);
		bindingContext.bindValue(observeVisibleStyledTextObserveWidget, errorexistDressingObserveValue, null, null);
		//
		IObservableValue observeTextEtagetxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(etagetxt);
		IObservableValue etageDressingObserveValue = BeanProperties.value("etage").observe(dressing);
		bindingContext.bindValue(observeTextEtagetxtObserveWidget, etageDressingObserveValue, null, null);
		//
		IObservableValue observeTextApptxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(apptxt);
		IObservableValue appartementDressingObserveValue = BeanProperties.value("appartement").observe(dressing);
		bindingContext.bindValue(observeTextApptxtObserveWidget, appartementDressingObserveValue, null, null);
		
		//
		return bindingContext;
	}
}
