package dressing.ui.dos;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.SeprationAxe;

import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;

public class DosCompositeWizard extends Composite {

	private DataBindingContext m_bindingContext;
	private dressing.controller.Piece2DCreator piece2DCreator = new dressing.controller.Piece2DCreator();
	private ComboViewer comboViewer;
	public DosCompositeWizard(Composite parent, int style, dressing.controller.Piece2DCreator newPiece2DCreator) {
		this(parent, style);
		setPiece2DCreator(newPiece2DCreator);
	}

	public DosCompositeWizard(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));
		
		Group group = new Group(this, SWT.NONE);
		group.setLayout(new GridLayout(2, false));
		GridData gd_group = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_group.heightHint = 97;
		gd_group.widthHint = 440;
		group.setLayoutData(gd_group);
		
		Label lblTypeDePorte = new Label(group, SWT.NONE);
		lblTypeDePorte.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTypeDePorte.setText("Type de dos");
		
		comboViewer = new ComboViewer(group, SWT.NONE);
		Combo combo = comboViewer.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer.setInput(DosType.values());
		if (piece2DCreator != null) {
			m_bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.controller.Piece2DCreator getPiece2DCreator() {
		return piece2DCreator;
	}

	public void setPiece2DCreator(dressing.controller.Piece2DCreator newPiece2DCreator) {
		setPiece2DCreator(newPiece2DCreator, true);
	}

	public void setPiece2DCreator(dressing.controller.Piece2DCreator newPiece2DCreator, boolean update) {
		piece2DCreator = newPiece2DCreator;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (piece2DCreator != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionComboViewer_1 = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue dostypePiece2DCreatorObserveValue = BeanProperties.value("dostype").observe(piece2DCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1, dostypePiece2DCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
