package dressing.model.usinage;

import java.util.HashMap;

import org.apache.commons.collections.map.HashedMap;

import com.badlogic.gdx.math.Vector3;

public enum Direction {
	XPLUS, XMINUS, YPLUS, YMINUS, ZPLUS, ZMINUS;

	public static Direction fromVector(Vector3 vec) {
		Vector3 normalized = vec.cpy().nor();
		HashMap<Direction, Float> dotProucts = new HashMap<Direction, Float>();
		for(Direction dir: Direction.values()) {
			dotProucts.put(dir, dir.toVector().dot(normalized));
		}
		Direction dir = null;
		float maxDot = Float.NEGATIVE_INFINITY;
		for(Direction direction: dotProucts.keySet()) {
			float dot = dotProucts.get(direction);
			if(dot > maxDot) {
				maxDot = dot;
				dir = direction;
			}
		}
		return dir;
	}
	
	public Vector3 toVector() {
		switch (this) {
		case XPLUS:
			return new Vector3(1,0,0);
		case XMINUS:
			return new Vector3(-1, 0, 0);
		case YPLUS:
			return new Vector3(0,1,0);
		case YMINUS:
			return new Vector3(0, -1, 0);
		case ZPLUS:
			return new Vector3(0,0,1);
		default:
			return new Vector3(0,0,-1);
		}
	}
}
