package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

import dressing.model.accessoire.SupportBlocTiroir;
import dressing.model.evalutor.Couple;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.model.usinage.Usinage;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.PublicParamGroup;
import param.impl.MaterialGroupImpl;


public class Space3DFree extends Space3D {
	
	protected  ArrayList<ModelAccessoire> accessoires = new ArrayList<ModelAccessoire>();
	protected  ArrayList<ModelQuincaillerie> quincailleries = new ArrayList<ModelQuincaillerie>();

	@Override
	public void addElement(DesignObject3D child) throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		if(child ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}
		if(canHold(child))
		{						
			if(child!=null)
			{
				child.addPropertyChangeListener(new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						// TODO Auto-generated method stub
						if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
							firePropertyChange("project.modify", null, child);
						}
						
					}
				});
			}
			
			childs.add(child);
			child.setParentdesign(this);			
			firePropertyChange("project.child.added", null, child);
		}
		else
		{
			throw new DesignException("Impossible d'ajouter "+child.getName());
		}

	}

	@Override
	public DesignObject3D clone() {
		Space3DFree space=new Space3DFree();
		try {
			space=(Space3DFree) this.copy((Space3DFree)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}

	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Space3DFree space=(Space3DFree) object;
		space=(Space3DFree) super.copy((Space3D)space);
		
		List<Charniere> charnieres = getcharniere(space);
		for (Charniere ch : charnieres) {
			DesignObject3D mother = DesignObject3D.getCharniereMother(ch, space.getRootCaisson());
			ch.setMother(mother);
			if (mother != null) {
				mother.addBaby(ch);
			}
		}
		List<SupportBlocTiroir> supportsblocktiroir = getSupportBlocTiroirs(space);
		for (SupportBlocTiroir ch : supportsblocktiroir) {
			DesignObject3D mother = DesignObject3D.getSupportBlocTiroirMother(ch, space.getRootCaisson());
			ch.setMother((Tirroir) mother);
			if (mother != null) {
				mother.addBaby(mother);
			}
		}
		List<Usinage> usins = getUsinages(space);
		for (Usinage usin : usins) {
			DesignObject3D mother = DesignObject3D.getUsinageMother(usin, space.getRootCaisson());
			usin.setMother(mother);
			if (mother != null) {
				mother.addBaby(usin);
			}
		}
		return super.copy(object);
	}
	public ArrayList<ModelAccessoire> getAccessoires() {
		if(accessoires==null) {
			accessoires=new ArrayList<ModelAccessoire>();
		}
		return accessoires;
	}

	public void setAccessoires(ArrayList<ModelAccessoire> accessoires) {
		this.accessoires = accessoires;
	}

	public ArrayList<ModelQuincaillerie> getQuincailleries() {
		if(quincailleries==null) {
			quincailleries=new ArrayList<ModelQuincaillerie>();
		}
		return quincailleries;
	}

	public void setQuincailleries(ArrayList<ModelQuincaillerie> quincailleries) {
		this.quincailleries = quincailleries;
	}

	public void addAccessoire(ModelAccessoire accessoire) {
		if(accessoires!=null && accessoire!=null)
		{
			ModelAccessoire accessoireold=null;
			for(ModelAccessoire access:accessoires) {
				if(access.getAccessoire().getAccessoire().equals(accessoire.getAccessoire().getAccessoire())) {
					accessoireold=access;
					break;
				}
			}
			if(accessoireold!=null) {
				accessoireold.setNumber(accessoireold.getNumber()+accessoire.getNumber());
			}else {
				accessoires.add(accessoire);
			}
		}
	}
	public void addQuincaillerie(ModelQuincaillerie quincaillerie) {
		if(quincailleries!=null && quincaillerie!=null)
		{
			ModelQuincaillerie quincaillerieold=null;
			for(ModelQuincaillerie access:quincailleries) {
				if(access.getQuincaillerie().getQuincaillerie().equals(quincaillerie.getQuincaillerie().getQuincaillerie())) {
					quincaillerieold=access;
					break;
				}
			}
			if(quincaillerieold!=null) {
				quincaillerieold.setNumber(quincaillerieold.getNumber()+quincaillerie.getNumber());
			}else {
				quincailleries.add(quincaillerie);
			}
		}
	}

	@Override
	public DesignObject3D getRoot() {
		if(mechanicDesignDefinition!=null) {
			return this;
		}
		return super.getRoot();
	}
	public DesignObject3D update() throws Exception {

		PublicParamGroup publicparams = this.mechanicDesignDefinition.getPublicparamgroup();

		MechanicPublicParam ep = publicparams.getParam("global.ep");
		MechanicPublicParam epback = publicparams.getParam("global.epback");
		MechanicPublicParam epface = publicparams.getParam("global.epface");

		ep.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getPrincipalmaterial().getEpaisseur()));
		epback.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getSecondmaterial().getEpaisseur()));
		epface.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getFacadeMaterial().getEpaisseur()));

		DesignObject3D parent = this.getParentdesign();
		clearautomatique();
		MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), parent, this,
				this.mechanicDesignDefinition, MechanicDesignCreator.update,false);

		return this;
	}
	public DesignObject3D refresh() throws Exception {

		DesignObject3D parent = this.getParentdesign();
		clearautomatique();
		MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), parent, this,
				this.mechanicDesignDefinition, MechanicDesignCreator.update,true);

		return this;
	}
	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		if(accessoires!=null)accessoires.clear();
		if(quincailleries!=null)quincailleries.clear();
		accessoires=null;
		quincailleries=null;
	}
}


