
package dressing.handlers.reporting;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;
import dressing.config.WorkspaceConfiguration;
import dressing.model.ProjectManager;
import dressing.reporting.data.handle.ReportConfigDialog;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;
import reporting.ReportWindow;
import reporting.htmlReporting.DressingProjectAssemblyReport;
import reporting.htmlReporting.ProjectReport;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class FicheAssemblyReportHandler {

	private boolean showUsin = false;
	private boolean showUsinCotes = false;
	private boolean groupedPiece = false;
	private ReportWindow window;

	@Execute
	public void execute(Shell shell, ParameterizedCommand cmd) {
		// devis
		DressingProjectAssemblyReport assemblyReport = new DressingProjectAssemblyReport(
				ProjectManager.getManager().getCurrentProject());
		assemblyReport.setShell(shell);
		ReportConfigDialog dialog = new ReportConfigDialog(shell, assemblyReport.getProjectcoupe().getTotals());
		dialog.open();
		assemblyReport.generate(true);
	}

	@CanExecute
	public boolean canExecute() {

		return ProjectManager.getManager().getCurrentProject() != null;
	}

}