package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.ui.etagere.EtagereWizard;

public class AddEtagereWizardHandler {
	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){

		Object o = selectionService.getSelection("dressing.part.tree");
		Object o1 = selectionService.getSelection("dressing.part.editor3d");
		
		Object selctedspace =o1;
		if(o1 != null && o1 instanceof Space3D  )
		{
			selctedspace = o1;
		}
		else if(o != null && o instanceof Space3D)
		{
			selctedspace = o;
		}
		//Voire l element de l arbre selectionne
		if((selctedspace!=null) && (selctedspace instanceof Space3D ))
		{		
			Space3D space =(Space3D)selctedspace;
			EtagereWizard etgwizrad = ContextInjectionFactory.make(EtagereWizard.class,eclipsecontext);
			etgwizrad.setSpace3d(space);
			WizardDialog dialog = new WizardDialog(shell, etgwizrad);
			dialog.open();
				
		}	
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		Object o1 = selectionService.getSelection("dressing.part.editor3d");
		//Voire l element de l arbre selectionne
		if(o1!=null && o1 instanceof Space3D && !(o1 instanceof Space3DFree))
		{
			return true;
		}	
		else if(o!=null && o instanceof Space3D && !(o instanceof Space3DFree))
		{
			return true;
		}	
		return false;
	}
}
