/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package tech.frsdev.graphunit;

import java.awt.Point;
import java.util.ArrayList;

import dressing.cam.model.Rotationangle;

/**
 *
 * @author Administrator
 */
public class PolyLineDXFEntity {
   private static final long serialVersionUID = 352L;
        static String START_POLY_LINE = "0\n"
            + "POLYLINE\n"
            + "  6\n"
            + "SOLID\n"
            + "  8\n"
            + "0\n"
            + " 66\n"
            + "1\n"
            + " 10\n"
            + "0.0\n"
            + " 20\n"
            + "0.0\n"
            + " 30\n"
            + "0.0\n"
            + " 70\n"
            + "8\n";
    static String END_POLY_LINE = "  0\n"
            + "SEQEND\n";
    ArrayList<PointDXF> vertices = new ArrayList<>();
    boolean closed =true;
    //352
    public PolyLineDXFEntity(boolean closed) {
    }

    public void addVertices(PointDXF p) {
        vertices.add(p);
    }

    public String getDXFEntity(Rotationangle anglerotation) {
        String s = "";
        s += START_POLY_LINE;
        for (PointDXF p : vertices) {
            s += getVerticeDXFEntity(p,anglerotation);
        }
        s += END_POLY_LINE;
        return s;
    }

    private String getVerticeDXFEntity(PointDXF p,Rotationangle anglerotation) {
    	PointDXF pr =p.rotate(p, anglerotation);
        String s = "";
        s += "0\n"
                + "VERTEX\n"
                + "8\n"
                + "0\n"
                + " 10\n"
                + pr.x + "\n"
                + " 20\n"
                + pr.y + "\n"
                + " 30\n"
                + "0.0\n";
        return s;
    }
}
