package dressing.reporting.data.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentValuesGroup {

	private List<Attribute> values=new ArrayList<Attribute>();
	private Map<String,Attribute> valuesMap=new HashMap<String, Attribute>();
	public DocumentValuesGroup() {
		super();
	}
	
	public Attribute put(String key,String value) {
		Attribute attr=valuesMap.get(key);
		if(attr==null)
		{
			attr=new Attribute(key, value);
			
		}
		valuesMap.put(key, attr);
		values.add(attr);
		return attr;
	}
	public Attribute get(String key) {
		return valuesMap.get(key);
	}

	public List<Attribute> getValues() {
		return values;
	}
	
	public void removeInvisible() {
		getValues().removeAll(getValues().stream().filter(att-> !att.isVisible()).toList());
	}
	public Map<String, Attribute> getValuesMap() {
		return valuesMap;
	}
	public void addAttribute(Attribute attr) {
		valuesMap.put(attr.getName(), attr);
		values.add(attr);
	}
	public List<Attribute> list(){
		return getValues();
	}
}
