package dressing.model.stock;

import param.AccessoireInstance;
import param.QuincaillerieInstance;

public class ModelQuincaillerie extends Article{
	private QuincaillerieInstance  quincaillerie;
	private ModelAccessoire accessoire;
	
	public ModelQuincaillerie(QuincaillerieInstance quincaillerie) {
		super(quincaillerie);
		this.quincaillerie = quincaillerie;
	}

	public ModelQuincaillerie(QuincaillerieInstance quincaillerie, ModelAccessoire accessoire) {
		super(quincaillerie);
		this.quincaillerie = quincaillerie;
		this.accessoire = accessoire;
	}

	public QuincaillerieInstance getQuincaillerie() {
		return quincaillerie;
	}

	public void setQuincaillerie(QuincaillerieInstance quincaillerie) {
		ModelAccessoire oldValue = this.accessoire;
		this.quincaillerie = quincaillerie;
		firePropertyChange("accessoire", oldValue, accessoire);
	}

	public ModelAccessoire getAccessoire() {
		return accessoire;
	}

	public void setAccessoire(ModelAccessoire accessoire) {	
		ModelAccessoire oldValue = this.accessoire;
		this.accessoire = accessoire;
		firePropertyChange("accessoire", oldValue, accessoire);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((accessoire == null) ? 0 : accessoire.hashCode());
		result = prime * result + ((quincaillerie == null) ? 0 : quincaillerie.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		ModelQuincaillerie other = (ModelQuincaillerie) obj;
		if (accessoire == null) {
			if (other.accessoire != null)
				return false;
		} else if (!accessoire.equals(other.accessoire))
			return false;
		if (quincaillerie == null) {
			if (other.quincaillerie != null)
				return false;
		} else if (!quincaillerie.equals(other.quincaillerie))
			return false;
		return true;
	}
	

}
