package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.SupportMeubleBas;
import dressing.model.evalutor.Equation;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.SupportMeubleBasType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.usinage.Rainure;
/**
 * ce class represente le coeur de calcul pour les piece de type Bande ,
 * pour simplifier le code de calcul des composant 3D en créer un class 
 * pour les piece ou les composant compliquées dans son calcul pour rendre le code readable et maintainable 
 * @author Imed
 *
 */
public class SuportBasDebitageFormulas extends DebitageFormulas {

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof Piece2D && child instanceof SupportMeubleBas)
		{	
			Piece2D piece2d  = (Piece2D)parent;
			SupportMeubleBas support = (SupportMeubleBas)child;
			PieceType piecetype = piece2d.getPiecetype();
			SupportMeubleBasType supportType =support.getSupportType();
			FILL_SUPPORT_BAS_FROM_PARENT(piece2d, equations);
			switch (supportType) {
			
				case BACK_LEFT:
					ADDOrUpdateEquation("@this.l@", "@usin.supportbascote@", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.supportbascote@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.supportbasxretrait@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@usin.supportbaspretrait@ ", Equation.CALCULATION_AUTO,equations) ;				
					break;
				case BACK_RIGHT:
					ADDOrUpdateEquation("@this.l@", "@usin.supportbascote@", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.supportbascote@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - @usin.supportbasxretrait@ - @usin.supportbascote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@usin.supportbaspretrait@ ", Equation.CALCULATION_AUTO,equations) ;				
						
					break;
				case FRONT_LEFT:
					
					ADDOrUpdateEquation("@this.l@", "@usin.supportbascote@", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.supportbascote@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.supportbasxretrait@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.supportbaspretrait@ - @usin.supportbascote@ ", Equation.CALCULATION_AUTO,equations) ;				
					
					break;
				case FRONT_RIGHT:
					ADDOrUpdateEquation("@this.l@", "@usin.supportbascote@", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.supportbascote@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Parent.l@ -@usin.supportbasxretrait@ - @usin.supportbascote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.supportbaspretrait@ - @usin.supportbascote@  ", Equation.CALCULATION_AUTO,equations) ;				
					
					
					break;
				default:
					throw new DesignException(piecetype+" not found in debitage formula");
						
			}
			FILL_SUPPORT_BAS(support, equations);		
		}else
		{
			throw new DesignException("Unkown Debitage Formula");
		}
	}
	
	
	protected  void FILL_SUPPORT_BAS_FROM_PARENT(Piece2D piece2d,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@Parent.l@", ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.h@", ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.li@", ""+piece2d.getLongeurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.hi@", ""+piece2d.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.pi@", ""+piece2d.getProfondeurint(), Equation.CALCULATION_MANUAL,equations);				
		ADDOrUpdateEquation("@Parent.posx@", ""+piece2d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+piece2d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+piece2d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;			
	}
	private void FILL_SUPPORT_BAS(SupportMeubleBas support, ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@this.hi@", "@this.h@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.li@", "@this.l@", Equation.CALCULATION_AUTO,equations) ;
		
	}
}
