package dressing.model.accessoire;

import dressing.model.Accessoire;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.SupportMeubleBas;
import dressing.model.Tirroir;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.SuportBasDebitageFormulas;
import dressing.model.debitage.SuportBlocTiroirDebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.SupportPorteBoteilleType;
import dressing.model.types.TirroirType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

public class SupportBlocTiroir extends Accessoire {
	TirroirType supportType = TirroirType.TENDENBOX;	
	Direction direction =Direction.XMINUS;
	Tirroir mother=null;
	
	
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Usinage) {
			return true;
		}
		return false;
	}
	
	@Override
	public boolean isdrawable() {
		return false;
	}
	
	public TirroirType getSupportType() {
		return supportType;
	}
	public void setSupportType(TirroirType supportType) {
		TirroirType oldValue = this.supportType;
		this.supportType = supportType;
		firePropertyChange("supportType", oldValue, supportType);
	}
	public Direction getDirection() {
		return direction;
	}

	public void setDirection(Direction direction) {
		Direction oldValue = this.direction;
		this.direction = direction;
		firePropertyChange("direction", oldValue, direction);
	}
	
	public Tirroir getMother() {
		return mother;
	}

	public void setMother(Tirroir mother) {		
		Tirroir oldValue = this.mother;
		this.mother = mother;
		firePropertyChange("mother", oldValue, mother);
	}

	public SupportBlocTiroir clone() {

		SupportBlocTiroir support=new SupportBlocTiroir();
		support.setSupportType(getSupportType());
		support.setMother(getMother());
		support.setDirection(getDirection());
		support=(SupportBlocTiroir) this.copy(support);
		return support;
	}
	
	/**
	 * @author imed 
	 * @Bug 0001217 
	 * Créer les trous d'usinage necessaire pour cette Accessoire(Support Bas {@link SupportMeubleBas})
	 * créer les trous d'usinage 
	 */
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		
		Piece2D piece=(Piece2D) getParentdesign();

		Trou tr1=new Trou(getDirection());
		Trou tr2=new Trou(getDirection());
		
		tr1.setTrouType(TrouType.SUPPORT_BLOC_TIROIR_FRONT);
		tr2.setTrouType(TrouType.SUPPORT_BLOC_TIROIR_BACK);

		tr1.setMother(this); 
		tr2.setMother(this);
		
		tr1.setName("Trou Avant "+this.getName());
		tr2.setName("Trou Arriere "+this.getName());		
		
		tr1.setParentdesign(piece);
		tr2.setParentdesign(piece);

		
		tr1.constructDebitage();
		tr1.evaluate();
		
		tr2.constructDebitage();
		tr2.evaluate();
		
		piece.addElement(tr1);
		piece.addElement(tr2);

	}
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof SuportBlocTiroirDebitageFormulas)) {
			formulas = new SuportBlocTiroirDebitageFormulas();
		}
		return formulas; 
	}
	
}
