 
package dressing.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import param.Cavity;
import param.CondtionalEquation;
import param.DesignClassGroup;
import param.DesignClasse;
import param.Direction;
import param.Equation;
import param.Material;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicDesignGroup;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.Option;
import param.ParamFactory;
import param.ParamPackage;
import param.Rainure;
import param.Tool;
import param.ToolGroup;
import param.TriCavity;
import param.TypeDef;
import param.TypeDefElement;
import param.UsinageFaimlyGroup;
import param.UsinageFamily;
import param.UsinageNode;
import param.UsinageTrou;
import param.impl.CategoryGroupImpl;
import param.impl.CondtionalEquationImpl;
import param.impl.EquationImpl;
import param.impl.MechanicDesignImpl;
import param.impl.MechanicPrivateParamImpl;
import param.impl.MechanicPublicParamImpl;
import param.impl.OptionImpl;
import param.impl.ParamFactoryImpl;
import param.impl.TypeDefElementImpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class SaveSuperCadProjectAs {
	@Execute
	public void execute(Shell shell) {
		FileDialog dialog = new FileDialog(shell,SWT.SAVE);
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		dialog.setFilterPath(dirpath);
		SuperCadProject project=ProjectManager.getManager().getCurrentProject();
		String originName=project.getName();
		dialog.setFileName(project.getName());
		String filePath = dialog.open();
		if(filePath!=null && !filePath.isEmpty())
		{
			String tmpfolder=WorkspaceConfiguration.getProjectsPath() +File.separator+"tmp" ;
			File fTmpFolder=new File(tmpfolder);
			if (!fTmpFolder.exists()) {
				fTmpFolder.mkdirs();
				 System.err.println(fTmpFolder.setExecutable(true));	
			        System.err.println(fTmpFolder.setReadable(true));
			        System.err.println(fTmpFolder.setWritable(true,false));
			} 
			 File f = new File(filePath);
			 project.setName(f.getName());
			 String path=tmpfolder+File.separator+ project.getName();	
			 File f1=new File(path);
			
			ProjectManager.getManager().saveProject(project,path,false,false);
			 project.setName(originName);

			 
			 if(f.getParent()!=null)
			 {	
				 try {
			       FileOutputStream fos = new FileOutputStream(filePath+".cad");
				
			        ZipOutputStream zipOut = new ZipOutputStream(fos);
			        File fileToZip = f1;
			 
			        IOUtilities.zipFile(fileToZip, fileToZip.getName(), zipOut);
			        zipOut.close();
			        fos.close();
			        System.err.println(f1.setWritable(true)+" "+f1.setExecutable(true)+"  "+f1.setReadable(true));
			    	IOUtilities.deleteFolder(f1);
			 	} catch (FileNotFoundException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				 dirpath = f.getParent();
				 projectpref.put("directoryWrite", dirpath);
				 try {
					projectpref.flush();
				} catch (BackingStoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			 }
		}
//		changeIsHasOpposite();
//		changePrivateParamValues();
//		changeMechanicDesignOptionsNames();
//		changeBosoleLogic();
//		changePieceExistLogique();
//		changePorteCharniereLogic();//
//		addOppositeTrouDepthLogic();
//		AddPrivateParams();
//		setMechanicDesignIds();
//		IOUtilities.UnzipFile();
//		reglerPieceLAndPieceH();
//		reglerMaterial();
//		reglerMaterialTextures();
	}
	
	
	@CanExecute
	public boolean canExecute() {
		return   ProjectManager.getManager().getCurrentProject()!=null;
//		return true;
	}


	private void changeIsHasOpposite() {
		UsinageFaimlyGroup usinageFaimlyGroup=ModelProvider.getModelroot().getUsinageFamilies();
		UsinageFamily usinageFamily =usinageFaimlyGroup.getFamilies().get(0);
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		ToolGroup tools=ModelProvider.getModelroot().getTools();
		EList<Tool> ff=tools.getTools();
		Tool bosolTool=null;
		for(Tool tool:ff) {
			if(tool.getName().contentEquals("T8_25mm")) {
				bosolTool=tool;
			}
		}
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			for(MechanicDesignGroup designgroup:classe.getCategorie()) {
				if(designgroup!=null && designgroup.getMechanicdesign()!=null &&designgroup.getMechanicdesign().size()>0 )
				for(MechanicDesign design:designgroup.getMechanicdesign()) {
					if(design!=null && design.getMechanicelementgroup()!=null && design.getMechanicelementgroup().getMechanicdesignelment().size()>0)
					for(MechanicDesignElment element:design.getMechanicelementgroup().getMechanicdesignelment()) {
//						UsinageNode node = element.getUsinagenode();
//						if(node!=null && node.getUsinagetrou()!=null && node.getUsinagetrou().size()>0)
//						{
//								//
//							for(UsinageTrou trou:node.getUsinagetrou()) {
////								boolean ishasOpposite=	trou.isHaveopposite();
////								trou.setHaveOppositeExpression(String.valueOf(ishasOpposite));
//								if(trou!=null && trou.getOperations()!=null && trou.getOperations().size()>0 && bosolTool!=null)
//								if(trou.getName().contains("BOSOL_BOTTOM")||trou.getName().contains("BOSOL_TOP") ) {
//									trou.getOperations().get(0).setTool(bosolTool);
//								}
//							}
//								//
//							for(UsinageTrou trou:node.getUsinagetrou()) {
//								if(trou!=null && trou.getOperations()!=null && trou.getOperations().size()>0 )
//								if(trou.getName().contentEquals("USINAGE_CENTER_RIGHT")||trou.getName().contentEquals("USINAGE_CENTER_LEFT") ) {
//									String hasOppositeExpression=trou.getHaveOppositeExpression();
//									if(hasOppositeExpression!=null && !hasOppositeExpression.isEmpty()) {
//										trou.setExistexpression(hasOppositeExpression);
//										trou.setHaveOppositeExpression(String.valueOf(true));
//										trou.setHaveopposite(true);
//									}
//								}
//							}
								//
//						}
						//
//						if(node!=null && node.getCavities()!=null && node.getCavities().size()>0)
//							for(Cavity cavity:node.getCavities()) {
//								if(cavity!=null && cavity.getOperations()!=null && cavity.getOperations().size()>0 && bosolTool!=null)
//								{
//									cavity.getOperations().get(0).setTool(bosolTool);
//								}
//							}
						//
//						String name=element.getName();
//						char[]delimeters= {' ','_'};
//						String name1=WordUtils.capitalizeFully(name,delimeters);
//						element.setName(name1);
						//
						UsinageNode node = element.getUsinagenode();
						if(node!=null )
						{
							if( node.getUsinagetrou()!=null && node.getUsinagetrou().size()>0)
							{
								for(UsinageTrou trou:node.getUsinagetrou()) {
									trou.setUsinageFamily(usinageFamily);
								}
							}
							if( node.getUsinageRainure()!=null && node.getUsinageRainure().size()>0)
							{
								for(Rainure rn:node.getUsinageRainure()) {
									rn.setUsinageFamily(usinageFamily);

								}
							}
							if( node.getCavities()!=null && node.getCavities().size()>0)
							{
								for(Cavity cv:node.getCavities()) {
									cv.setUsinageFamily(usinageFamily);

								}
							}
							if( node.getUsinageTriCavity()!=null && node.getUsinageTriCavity().size()>0)
							{
								for(TriCavity cv:node.getUsinageTriCavity()) {
									cv.setUsinageFamily(usinageFamily);

								}
							}
						}
						
					}
				}
			}
		}
	}
	
	private void changePrivateParamValues() {
		UsinageFaimlyGroup usinageFaimlyGroup=ModelProvider.getModelroot().getUsinageFamilies();
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		String param="usin.usinagetroudepth";
		String value="21";
		boolean isType=false;
			
		boolean isPublic=false;
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {
			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null/* && (designgroup.getName().contentEquals("Elements Bas")||designgroup.getName().contentEquals("Block Tiroir"))*/
							&&designgroup.getMechanicdesign().size()>0 )
					{
						
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								try {
									if(isPublic) {
										if(isType) {
											design.setPublicParamType(param, value);
										}else {
											design.setPublicParamValue(param, value);
	
										}
									}else {
										if(isType) {
											design.setPrivateParamType(param, value);
										}else {
											design.setPrivateParamValue(param, value);
	
										}
									}
								} catch (Exception e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
							}
						
						
					}
				}
			}
		}
	}
	private void AddPrivateParams() {
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		CategoryGroupImpl types=(CategoryGroupImpl) ModelProvider.getModelroot().getCategorie();
		EList<TypeDef> typeDefs=types.getTypedef();
		String param="trou.proftourillon";
		String value="22";
		String name ="Profondeur trou tourillon";
		String label =name;

		String type="FACADE_TYPE";
		String typeElement="COLOR";
		TypeDef def=null;
		TypeDefElement defElement=null;
		boolean isType=false;
			
		boolean isPublic=false;
		if(isType) {
			if(type!=null && !type.isEmpty())
			{
				for(TypeDef defs:typeDefs) {
					if(defs.getKey().contentEquals(type)) {
						def=defs;
						break;
					}
				}
				if(def!=null && typeElement!=null && !typeElement.isEmpty()) {
					defElement=def.getElement(typeElement);
				}
			}
			
		}
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {
			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null &&  !designgroup.getName().contentEquals("Fausse facade")/*&&!designgroup.getName().contentEquals("Elements Haut")
							/*designgroup.getName().contentEquals("Elements Bas")*/&&
							designgroup.getMechanicdesign().size()>0 )
					{
							mechanicDeisn:
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								try {
									if(isPublic) {
										try {
											MechanicPublicParam old=design.getPublicParam(param);
											if(old!=null) {
												continue mechanicDeisn;
											}
										} catch (Exception e) {
											// TODO Auto-generated catch block
											e.printStackTrace();
										}
										MechanicPublicParamImpl publicParam=(MechanicPublicParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPublicParam();
										publicParam.setName(name);
										publicParam.setKey(param);
										publicParam.setUserlabel(label);
										publicParam.setChangeable(true);
										
										if(isType) {
											publicParam.setTypedef(def);
											publicParam.setTypedefelement(defElement);
											
										}else {
											publicParam.setDefaultvalue(value);
	
										}
										design.getPublicparamgroup().getMechanicpublicparam().add(publicParam);
									}else {
										try {
											MechanicPrivateParam old=design.getPrivateParam(param);
											if(old!=null) {
												continue mechanicDeisn;
											}
										} catch (Exception e) {
											// TODO Auto-generated catch block
											e.printStackTrace();
										}
										MechanicPrivateParamImpl privateParam=(MechanicPrivateParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPrivateParam();
										privateParam.setName(name);
										privateParam.setKey(param);

										if(isType) {
											privateParam.setTypedef(def);
											privateParam.setTypedefelement(defElement);
										}else {
											privateParam.setValue(value);
	
										}
										design.getPrivateparamgroup().getMechanicprivateparam().add(privateParam);

									}
								} catch (Exception e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
							}
						
						
					}
				}
			}
		}
	}
	private void changePieceExistLogique() {
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		String pieceType="DOS_INTERIEUR";
		String value="ommit_dos=='false'";

		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {
			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null /*&& !designgroup.getName().contentEquals("Colonnes")||designgroup.getName().contentEquals("Elements Bas"))*/
							&&designgroup.getMechanicdesign().size()>0 )
					{
						
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								try {
									if(design!=null && design.getMechanicelementgroup()!=null && design.getMechanicelementgroup().getMechanicdesignelment().size()>0) {
										for(MechanicDesignElment element:design.getMechanicelementgroup().getMechanicdesignelment()) {
											if(element.getTypedefelement().getKey().contentEquals(pieceType)) {
												String existExpression=element.getExistexpression();
												if(existExpression!=null && !existExpression.isEmpty()) {
													existExpression="("+existExpression+")&&"+value;
													element.setExistexpression(existExpression);
												}else {
													element.setExistexpression(value);
												}
											}
										}
									}
								} catch (Exception e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
							}
						
						
					}
				}
			}
		}
	}
	private void reglerMaterial() {
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		Material matprincipal=ModelProvider.getModelroot().getMaterialgroup().getMaterial().get(0);
		Material matface=ModelProvider.getModelroot().getMaterialgroup().getMaterial().get(1);
		Material matdos=ModelProvider.getModelroot().getMaterialgroup().getMaterial().get(ModelProvider.getModelroot().getMaterialgroup().getMaterial().size()-1);
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {
			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null /*&& !designgroup.getName().contentEquals("Colonnes")||designgroup.getName().contentEquals("Elements Bas"))*/
							&&designgroup.getMechanicdesign().size()>0 )
					{
						
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								try {
									design.setPrincipalmaterial(matprincipal);
									design.setFacadeMaterial(matface);
									design.setSecondmaterial(matdos);
									if(design!=null && design.getMechanicelementgroup()!=null && design.getMechanicelementgroup().getMechanicdesignelment().size()>0) {
										for(MechanicDesignElment element:design.getMechanicelementgroup().getMechanicdesignelment()) {
											if(element!=null) {
												if(element.isFaceMaterial()) {
													element.setMaterial(matface);
												}else if(element.isPrimaryMaterial()) {
													element.setMaterial(matprincipal);

												}else if(element.isBackMaterial()) {
													element.setMaterial(matdos);

												}else {
													element.setMaterial(matprincipal);

												}
											}
										}
									}
								} catch (Exception e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
							}
						
						
					}
				}
			}
		}
	}
	private void reglerMaterialTextures() {
		String texture="POPLAR.jpg";
			
		for(Material mat:ModelProvider.getModelroot().getMaterialgroup().getMaterial()) {
			
			mat.setImage(texture);
		}
	}
	private void changeMechanicDesignOptionsNames() {
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null &&designgroup.getMechanicdesign().size()>0 )
					{
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								String designName=design.getName();
								System.err.println("Start:\t\t"+designName);
								if(design.getOptions()!=null && design.getOptions().getOptions()!=null && design.getOptions().getOptions().size()>0)
								{
									for(Option op:design.getOptions().getOptions()) {
										String opName=op.getName();
										System.err.println("Start Option:\t\t"+opName);
										//
//										String value=designName+" "+opName;
//										value=value.replace("Element", "");
//										char[]delimeters= {' ','_'};
//										String name1=WordUtils.capitalizeFully(value,delimeters);
//										op.setName(name1);
//										op.setLabel(name1);
										//
//										if(opName.startsWith(" ")) {
//											String name1=opName.substring(1); 
//											op.setName(name1);
//											op.setLabel(name1);
//										}
										String label=opName.replace(" 2p", "");
										op.setName(label);
									}
									
								}
							}
						
						
					}
				}
			}
		}
	}

	private void changeBosoleLogic() {
		UsinageFaimlyGroup usinageFaimlyGroup = ModelProvider.getModelroot().getUsinageFamilies();
		UsinageFamily usinageFamily = usinageFaimlyGroup.getFamilies().get(0);
		DesignClassGroup classes = ModelProvider.getModelroot().getClasses();
		// parcourir les MecanicDesignClasses (cuisine /Dressing..)
		if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
			for (DesignClasse classe : classes.getDesignClasse()) {
				// parcourir les MecanicDesign Groups|famille (Haut /Bas/Colonnes...)
				if (classe != null && classe.getCategorie() != null && classe.getCategorie().size() > 0) {
					for (MechanicDesignGroup designgroup : classe.getCategorie()) {
						// parcourir les MecanicDesign
						if (designgroup != null && designgroup.getMechanicdesign() != null&& designgroup.getMechanicdesign().size() > 0) {
							for (MechanicDesign design : designgroup.getMechanicdesign()) {
								// parcourir les MecanicDesignElemnts (Pieces )
								if (design != null && design.getMechanicelementgroup() != null && design.getMechanicelementgroup().getMechanicdesignelment().size() > 0) {
									for (MechanicDesignElment element : design.getMechanicelementgroup().getMechanicdesignelment()) {
										// parcourir les Usinage
										UsinageNode node = element.getUsinagenode();
										if (node != null && node.getUsinagetrou() != null&& node.getUsinagetrou().size() > 0) {
											for (UsinageTrou trou : node.getUsinagetrou()) {

												if (trou != null && trou.getUsinageFamily()!=null) {
//													String existExpression=trou.getExistexpression();
//													String haveOppositeExpression=trou.getHaveOppositeExpression();
//													if(trou.getUsinageFamily().getName().contentEquals("Usinage")) {
//														if(existExpression!=null && !existExpression.isEmpty()) {
//															if(existExpression.contains("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'")) {
//																String s=existExpression.replace("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'", "USE_BOSOLRIGHT=='false'");
//																trou.setExistexpression(s);
//															}
//															if(existExpression.contains("(POSITION_TYPE=='DROITE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'")) {
//																String s=existExpression.replace("(POSITION_TYPE=='DROITE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'", "USE_BOSOLLEFT=='false'");
//																trou.setExistexpression(s);
//															}
//														}
//														if(haveOppositeExpression!=null && !haveOppositeExpression.isEmpty()) {
//															if(haveOppositeExpression.contains("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'")){
//																String s=haveOppositeExpression.replace("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'", "USE_BOSOLRIGHT=='false'");
//																trou.setHaveOppositeExpression(s);
//															}
//															if(haveOppositeExpression.contains("( POSITION_TYPE=='DROITE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'")) {
//																String s=haveOppositeExpression.replace("( POSITION_TYPE=='DROITE' || POSITION_TYPE=='MILIEU')|| USE_BOSOL=='false'", "USE_BOSOLLEFT=='false'");
//																trou.setHaveOppositeExpression(s);
//															}
//														}
//
//													}
//													if(trou.getUsinageFamily().getName().contentEquals("Bosol")) {
//														if(existExpression!=null && !existExpression.isEmpty()) {
//															if(existExpression.contains("(POSITION_TYPE=='DROITE' || POSITION_TYPE=='MONO')&&USE_BOSOL=='true'")) {
//																String s=existExpression.replace("(POSITION_TYPE=='DROITE' || POSITION_TYPE=='MONO')&&USE_BOSOL=='true'", "USE_BOSOLRIGHT=='true'");
//																trou.setExistexpression(s);
//															}
//															if(existExpression.contains("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MONO')&&USE_BOSOL=='true'")) {
//																String s=existExpression.replace("(POSITION_TYPE=='GAUCHE' || POSITION_TYPE=='MONO')&&USE_BOSOL=='true'", "USE_BOSOLLEFT=='true'");
//																trou.setExistexpression(s);
//															}
//														}
//														
//													}
//													if(trou.getName().contains("LEFT")&& !trou.getName().contains("BOSOL")&& trou.getDirection().equals(Direction.XMINUS)) {
//														System.err.println(design.getName()+"\t "+element.getName()+"\t"+trou.getName());
//													}
														
												}
											}
										}

									}

								}
							}
						}
					}
				}
			}
		}
	}
	private void reglerPieceLAndPieceH() {
		UsinageFaimlyGroup usinageFaimlyGroup = ModelProvider.getModelroot().getUsinageFamilies();
		UsinageFamily usinageFamily = usinageFaimlyGroup.getFamilies().get(0);
		DesignClassGroup classes = ModelProvider.getModelroot().getClasses();
		// parcourir les MecanicDesignClasses (cuisine /Dressing..)
		if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
			for (DesignClasse classe : classes.getDesignClasse()) {
				// parcourir les MecanicDesign Groups|famille (Haut /Bas/Colonnes...)
				if (classe != null && classe.getCategorie() != null && classe.getCategorie().size() > 0) {
					for (MechanicDesignGroup designgroup : classe.getCategorie()) {
						// parcourir les MecanicDesign
						if (designgroup != null && designgroup.getMechanicdesign() != null&& designgroup.getMechanicdesign().size() > 0) {
							for (MechanicDesign design : designgroup.getMechanicdesign()) {
								// parcourir les MecanicDesignElemnts (Pieces )
								if (design != null && design.getMechanicelementgroup() != null && design.getMechanicelementgroup().getMechanicdesignelment().size() > 0) {
									for (MechanicDesignElment element : design.getMechanicelementgroup().getMechanicdesignelment()) {
										if(element.getEquation()!=null && element.getEquation().size()>0) {
											for( Equation eq:element.getEquation()) {
												if(eq.getKey().contentEquals("this.pieceL")) {
													eq.setExpression("Math.max(Math.max(@this.h@,@this.p@),@this.l@)");
												}
												if(eq.getKey().contentEquals("this.pieceH")) {
													eq.setExpression("(@this.h@+@this.p@+@this.l@)-Math.max(Math.max(@this.h@,@this.p@),@this.l@) -Math.min(Math.min(@this.h@,@this.p@),@this.l@)");

												}
											}
										}
									}
									
								}
							}
						}
					}
				}
			}
		}
	}
	private void changePorteCharniereLogic() {
		UsinageFaimlyGroup usinageFaimlyGroup = ModelProvider.getModelroot().getUsinageFamilies();
		UsinageFamily usinageFamily = usinageFaimlyGroup.getFamilies().get(0);
		DesignClassGroup classes = ModelProvider.getModelroot().getClasses();
		String expressionBosolLeft="USE_BOSOLLEFT=='true'";
		String expressionBosolRight="USE_BOSOLRIGHT=='true'";
		String viseDiameter="@usin.Visetroudiametre@";
		String depth="@usin.usinagetroudepth@";
		String lateraldepth="@usin.usinageLateraltroudepth@";
		String bosoldiameter="@usin.usinagetroudiametre@";
		String key=null;
		String expression=null;
		
		// parcourir les MecanicDesignClasses (cuisine /Dressing..)
		if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
			for (DesignClasse classe : classes.getDesignClasse()) {
				// parcourir les MecanicDesign Groups|famille (Haut /Bas/Colonnes...)
				if (classe != null && classe.getCategorie() != null && classe.getCategorie().size() > 0) {
					for (MechanicDesignGroup designgroup : classe.getCategorie()) {
						// parcourir les MecanicDesign
						if (designgroup != null && designgroup.getMechanicdesign() != null&& designgroup.getMechanicdesign().size() > 0) {
							for (MechanicDesign design : designgroup.getMechanicdesign()) {
								// parcourir les MecanicDesignElemnts (Pieces )
								if (design != null && design.getMechanicelementgroup() != null && design.getMechanicelementgroup().getMechanicdesignelment().size() > 0) {
									for (MechanicDesignElment element : design.getMechanicelementgroup().getMechanicdesignelment()) {
										// parcourir les Usinage
//										if(element.getTypedefelement().getKey().contentEquals("PORTE_GAUCHE")||element.getTypedefelement().getKey().contentEquals("PORTE_DROITE"))
//										{
											UsinageNode node = element.getUsinagenode();
											if (node != null && node.getUsinagetrou() != null&& node.getUsinagetrou().size() > 0) {
												for (UsinageTrou trou : node.getUsinagetrou()) {

													if (trou != null && trou.getUsinageFamily()!=null) {
														
														if(trou.getUsinageFamily().getName().contentEquals("Usinage")/*
																||trou.getUsinageFamily().getName().contentEquals("Charniere Porte")
																||trou.getUsinageFamily().getName().contentEquals("Charniere Porte Grand Trou")*/) {
//															String posY=trou.getY();
//															if(posY.contains("usin.charnierehtrouretrait")) {
////																EquationImpl eq=(EquationImpl) ParamFactoryImpl.eINSTANCE.createEquation();
////																eq.setKey("this.posy");
////																eq.setExpression(posY);
////																String posY2=posY.replace("usin.charnierehtrouretrait", "usin.charnierehtrouretrait2");
////																CondtionalEquationImpl eq1=(CondtionalEquationImpl) ParamFactoryImpl.eINSTANCE.createCondtionalEquation();
////																eq1.setExpression(posY2);
////																eq1.setWhenexpression("global_h<PORTE_MAXWIDTH");
////																eq1.setName("cas d'element hauteur inferieur 60 ");
////																eq.getCondtionalequation().add(eq1);
////																trou.getEquation().add(eq);
//																if(trou.getEquation()!=null && trou.getEquation().size()>0) {
//																	Equation eq=trou.getEquation().get(0);
//																	if(eq!=null&& eq.getCondtionalequation()!=null && eq.getCondtionalequation().size()>0) {
//																		CondtionalEquationImpl eq1=(CondtionalEquationImpl) eq.getCondtionalequation().get(0);
//																		eq1.setWhenexpression(eq1.getWhenexpression().replace("global_h", "PARENT.getHauteurext()"));
//																	}
//																}
//															}
															//
//															if(trou.getEquation()!=null && trou.getEquation().size()>0) {
//																for(Equation eq:trou.getEquation()) {
//																	if(eq!=null&& eq.getCondtionalequation()!=null&& eq.getCondtionalequation().size()>0) {
//																		for(CondtionalEquation eqC:eq.getCondtionalequation()) {
//																			String expression=eqC.getWhenexpression();
//																			expression=expression.replace("PORTE_MAXWIDTH", "charniere_maxlongeur");
//																			eqC.setWhenexpression(expression);
//																		}
//																	}
//																}
//															}
															//
//															EquationImpl eq=(EquationImpl) ParamFactoryImpl.eINSTANCE.createEquation();
//															eq.setKey("this.troudiametre");
//															eq.setExpression("@usin.supportbastroudiametre@");
//															CondtionalEquationImpl eq1=(CondtionalEquationImpl) ParamFactoryImpl.eINSTANCE.createCondtionalEquation();
//															eq1.setExpression(diameter);
//															eq1.setWhenexpression(expression);
//															eq1.setName("Embase espanoel");
//															eq.getCondtionalequation().add(eq1);
//															trou.getEquation().add(eq);
															//
															//
//															if(!trou.getName().contains("USINAGE_SUPPORT_BAS_BACK_LEFT BACK_LEFT")
//																	&&!trou.getName().contains("USINAGE_SUPPORT_BAS_FRONT_LEFT FRONT_LEFT")
//																	&&!trou.getName().contains("USINAGE_SUPPORT_BAS_BACK_RIGHT BACK_RIGHT")
//																	&&!trou.getName().contains("USINAGE_SUPPORT_BAS_FRONT_RIGHT FRONT_RIGHT")
//																	&&!trou.getName().contains("USINAGE_SUPPORT_BAS_FRONT_MIDDLE FRONT_LEFT")) {
//																String existExpression=trou.getExistexpression();
//																if(existExpression!=null && !existExpression.isEmpty()) {
//																	existExpression="("+existExpression+")&&"+expression;
//																}else {
//																	existExpression=expression;
//																}
//																trou.setExistexpression(existExpression);
//															}
															//
															
															//
															
//															if(trou.getProfondeur().contains(lateraldepth)) {
//																trou.setDiameter(viseDiameter);
//															}
//															if(trou.getOppositeProfondeur().contains(lateraldepth)) {
//																trou.setOppositeDiameter(viseDiameter);
//															}
																	//
															if(trou.getProfondeur().contains(lateraldepth)) {
																key="@this.troudiametre@";
																
															}
															if(trou.getOppositeProfondeur().contains(lateraldepth)) {
																key="@opposite.troudiametre@";
															}
															if((trou.getExistexpression()!=null && !trou.getExistexpression().isEmpty()&& trou.getExistexpression().contains("USE_BOSOLLEFT"))
																	||(trou.getHaveOppositeExpression()!=null && !trou.getHaveOppositeExpression().isEmpty()&& trou.getHaveOppositeExpression().contains("USE_BOSOLLEFT")))
															{
																expression=expressionBosolLeft;
															}
															if((trou.getExistexpression()!=null && !trou.getExistexpression().isEmpty()&& trou.getExistexpression().contains("USE_BOSOLRIGHT"))
																	||(trou.getHaveOppositeExpression()!=null && !trou.getHaveOppositeExpression().isEmpty()&& trou.getHaveOppositeExpression().contains("USE_BOSOLRIGHT")))
															{
																expression=expressionBosolRight;
															}
															if(key!=null && expression!=null) {
																EquationImpl eq=(EquationImpl) ParamFactoryImpl.eINSTANCE.createEquation();
																eq.setKey(key);
																eq.setExpression(viseDiameter);
																CondtionalEquationImpl eq1=(CondtionalEquationImpl) ParamFactoryImpl.eINSTANCE.createCondtionalEquation();
																eq1.setExpression(bosoldiameter);
																eq1.setWhenexpression(expression);
																eq1.setName("trou usinage dimatre en cas du bosol");
																eq.getCondtionalequation().add(eq1);
																trou.getEquation().add(eq);
															}
															
															key=null;
															expression=null;
															//
														}
															
													}
												}
											}
//										}
										

									}

								}
							}
						}
					}
				}
			}
		}
	}
	private void addOppositeTrouDepthLogic() {
		UsinageFaimlyGroup usinageFaimlyGroup = ModelProvider.getModelroot().getUsinageFamilies();
		UsinageFamily usinageFamily = usinageFaimlyGroup.getFamilies().get(0);
		DesignClassGroup classes = ModelProvider.getModelroot().getClasses();
		// parcourir les MecanicDesignClasses (cuisine /Dressing..)
		if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
			for (DesignClasse classe : classes.getDesignClasse()) {
				// parcourir les MecanicDesign Groups|famille (Haut /Bas/Colonnes...)
				if (classe != null && classe.getCategorie() != null && classe.getCategorie().size() > 0) {
					for (MechanicDesignGroup designgroup : classe.getCategorie()) {
						// parcourir les MecanicDesign
						System.err.println("famille :\t"+designgroup.getName());
						if (designgroup != null && designgroup.getMechanicdesign() != null&& designgroup.getMechanicdesign().size() > 0) {
							for (MechanicDesign design : designgroup.getMechanicdesign()) {
								// parcourir les MecanicDesignElemnts (Pieces )
								System.err.println("design :\t"+design.getName());

								if (design != null && design.getMechanicelementgroup() != null && design.getMechanicelementgroup().getMechanicdesignelment().size() > 0) {
									for (MechanicDesignElment element : design.getMechanicelementgroup().getMechanicdesignelment()) {
//										// parcourir les Usinage
//										if(element.getTypedefelement().getKey().contentEquals("PORTE_GAUCHE")||element.getTypedefelement().getKey().contentEquals("PORTE_DROITE"))
//										{
											UsinageNode node = element.getUsinagenode();
											if (node != null && node.getUsinagetrou() != null&& node.getUsinagetrou().size() > 0) {
												for (UsinageTrou trou : node.getUsinagetrou()) {
													
													//
//													if (trou != null && trou.getUsinageFamily()!=null) {
//														
//														if(trou.getUsinageFamily().getName().contentEquals("Usinage")) {
//															trou.setProfondeur("@usin.usinageLateraltroudepth@");
////															System.err.print("element:\t"+element.getName()+"\t\t type:\t"+element.getTypedefelement().getName());
////															System.err.println("\t Trou:"+trou.getName()+"  D  "+trou.getDirection().getLiteral());
////															System.err.print("\t Trou depth:\t"+trou.getProfondeur());
////															System.err.println("|"+trou.getOppositeProfondeur());
//
//														}
//													}
													//
													if (trou != null) {
														String diameter=trou.getDiameter();
														trou.setOppositeDiameter(diameter);
														
													}
												}
											}
//										}
										

									}

								}
							}
						}
					}
				}
			}
		}
	}

	private void setMechanicDesignIds() {
		DesignClassGroup classes=	ModelProvider.getModelroot().getClasses();
		if(classes!=null && classes.getDesignClasse()!=null&& classes.getDesignClasse().size()>0)
			
		for(DesignClasse classe:classes.getDesignClasse()) {
			if(classe!=null && classe.getCategorie()!=null &&classe.getCategorie().size()>0)
			{
				for(MechanicDesignGroup designgroup:classe.getCategorie()) {			
					if(designgroup!=null && designgroup.getMechanicdesign()!=null &&designgroup.getMechanicdesign().size()>0 )
					{
							for(MechanicDesign design:designgroup.getMechanicdesign()) {
								design.setModelId(UUID.randomUUID());
								
							}
						
						
					}
				}
			}
		}
	}

}