package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Dressing;
import dressing.model.Space3D;
import dressing.ui.charniere.CharniereWizard;
import dressing.ui.etagere.EtagereWizard;

public class AddCharniereWizardHandler {
	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){

		Object selctedspace = selectionService.getSelection("dressing.part.tree");
		
		//Voire l element de l arbre selectionne
		if((selctedspace!=null) && (selctedspace instanceof Space3D ))
		{		
			Space3D space =(Space3D)selctedspace;
			CharniereWizard etgwizrad = ContextInjectionFactory.make(CharniereWizard.class,eclipsecontext);
			etgwizrad.setSpace3d(space);
			WizardDialog dialog = new WizardDialog(shell, etgwizrad);
			dialog.open();
				
		}	
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof Space3D && !(o instanceof Dressing))
		{
			return true;
		}	
		return false;
	}
}
