/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.state.NoSaveStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;

public class CompositeCheatSheetSaveHelper {
    private static final String DOT_XML = ".xml";
    private Map<String, IMemento> taskMementoMap;
    private ICheatSheetStateManager stateManager;

    public CompositeCheatSheetSaveHelper(ICheatSheetStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public IStatus loadCompositeState(CompositeCheatSheetModel model, Map<String, String> layoutData) {
        if (this.stateManager instanceof NoSaveStateManager) {
            return Status.OK_STATUS;
        }
        XMLMemento readMemento = CheatSheetPlugin.getPlugin().readMemento(model.getId() + DOT_XML);
        if (readMemento == null) {
            return Status.OK_STATUS;
        }
        this.taskMementoMap = this.createTaskMap(readMemento);
        this.loadTaskState(this.taskMementoMap, (AbstractTask)model.getRootTask());
        this.loadCheatsheetManagerData(readMemento, model.getCheatSheetManager());
        this.loadLayoutData(readMemento, layoutData);
        model.sendTaskChangeEvents();
        return Status.OK_STATUS;
    }

    private Map<String, IMemento> createTaskMap(XMLMemento readMemento) {
        IMemento[] tasks;
        HashMap<String, IMemento> map = new HashMap<String, IMemento>();
        IMemento[] iMementoArray = tasks = readMemento.getChildren("task");
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento task = iMementoArray[n2];
            String taskId = task.getString("id");
            if (taskId != null) {
                map.put(taskId, task);
            }
            ++n2;
        }
        return map;
    }

    private void loadTaskState(Map<String, IMemento> taskMap, AbstractTask task) {
        String state;
        ICompositeCheatSheetTask[] children = task.getSubtasks();
        IMemento memento = taskMap.get(task.getId());
        if (memento != null && (state = memento.getString("state")) != null) {
            task.setStateNoNotify(Integer.parseInt(state));
        }
        if (task instanceof TaskGroup) {
            ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ICompositeCheatSheetTask element = iCompositeCheatSheetTaskArray[n2];
                this.loadTaskState(taskMap, (AbstractTask)element);
                ++n2;
            }
            ((TaskGroup)task).checkState();
        }
    }

    private void loadCheatsheetManagerData(XMLMemento readMemento, ICheatSheetManager manager) {
        IMemento[] children;
        if (manager == null) {
            return;
        }
        IMemento[] iMementoArray = children = readMemento.getChildren("cheatSheetManager");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            String key = childMemento.getString("key");
            String value = childMemento.getString("value");
            manager.setData(key, value);
            ++n2;
        }
    }

    private void loadLayoutData(XMLMemento readMemento, Map<String, String> layoutData) {
        IMemento[] children;
        if (layoutData == null) {
            return;
        }
        IMemento[] iMementoArray = children = readMemento.getChildren("layout");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            String key = childMemento.getString("key");
            String value = childMemento.getString("value");
            layoutData.put(key, value);
            ++n2;
        }
    }

    public IStatus saveCompositeState(CompositeCheatSheetModel model, Map<String, String> layoutData) {
        if (this.stateManager instanceof NoSaveStateManager) {
            return Status.OK_STATUS;
        }
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)"compositeCheatSheetState");
        writeMemento.putString("id", model.getId());
        this.saveTaskState((IMemento)writeMemento, (AbstractTask)model.getRootTask());
        this.saveCheatSheetManagerData(writeMemento, model.getCheatSheetManager());
        this.taskMementoMap = this.createTaskMap(writeMemento);
        if (layoutData != null) {
            this.saveMap(writeMemento, layoutData, "layout");
        }
        return CheatSheetPlugin.getPlugin().saveMemento(writeMemento, model.getId() + DOT_XML);
    }

    private void saveCheatSheetManagerData(XMLMemento writeMemento, ICheatSheetManager manager) {
        if (!(manager instanceof CheatSheetManager)) {
            return;
        }
        Map<String, String> data = ((CheatSheetManager)manager).getData();
        this.saveMap(writeMemento, data, "cheatSheetManager");
    }

    private void saveMap(XMLMemento writeMemento, Map<String, String> data, String tag) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            IMemento childMemento = writeMemento.createChild(tag);
            childMemento.putString("key", key);
            childMemento.putString("value", value);
        }
    }

    private void saveTaskState(IMemento writeMemento, AbstractTask task) {
        IMemento childMemento = writeMemento.createChild("task");
        childMemento.putString("id", task.getId());
        childMemento.putString("state", Integer.toString(task.getState()));
        if (task instanceof IEditableTask && task.getState() != 0) {
            TaskEditor editor = this.getEditor(task);
            if (editor != null) {
                IMemento taskDataMemento = childMemento.createChild("taskData");
                editor.saveState(taskDataMemento);
            } else {
                IMemento taskData = this.getTaskMemento(task.getId());
                if (taskData != null) {
                    IMemento previousDataMemento = childMemento.createChild("taskData");
                    previousDataMemento.putMemento(taskData);
                }
            }
        }
        ICompositeCheatSheetTask[] subtasks = task.getSubtasks();
        int i = 0;
        while (i < subtasks.length) {
            this.saveTaskState(writeMemento, (AbstractTask)subtasks[i]);
            ++i;
        }
    }

    private TaskEditor getEditor(AbstractTask task) {
        if (task instanceof EditableTask) {
            return ((EditableTask)task).getEditor();
        }
        return null;
    }

    public IMemento getTaskMemento(String id) {
        if (this.taskMementoMap == null) {
            return null;
        }
        IMemento childMemento = this.taskMementoMap.get(id);
        if (childMemento == null) {
            return null;
        }
        return childMemento.getChild("taskData");
    }

    public void clearTaskMementos() {
        this.taskMementoMap = null;
    }

    public void clearTaskMemento(String id) {
        if (this.taskMementoMap != null) {
            this.taskMementoMap.remove(id);
        }
    }
}

