package supercad.p2.update;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class UpdateHandler {

	 private String repo_loc ;
		//private static String REPOSITORY_LOC = "";
		private IWorkbench workbench;

		    public  void setBuildNumber(String lastbuildNumber) {
		    	//repo_loc = ConfigurationManager.getProperty("URL_P2_SITE_UPDATE") + lastbuildNumber; 
		    	repo_loc = ConfigurationManager.getProperty("URL_P2_SITE_UPDATE");
		        //REPOSITORY_LOC = "https://cadp2site.webdemo.frsdev.ovh/apps/supercad/update/" + lastbuildNumber;
		        //REPOSITORY_LOC = getP2UpdateSiteUrl() + lastbuildNumber;
//		    	String REPOSITORY_LOC = Platform.getDebugOption("URL_P2_SITE_UPDATE");
		        System.out.println("URL de mise à jour configurée : " + repo_loc);
		        System.out.println("URL de mise à jour configurée : " + repo_loc);
		    }

		    public void execute(final IProvisioningAgent agent, IWorkbench workbench) {
		    	  if (agent == null) {
		              System.err.println("ProvisioningAgent is null - cannot perform update");
		              return;
		          }
		        this.workbench = workbench;
		        System.out.println("Début du processus de mise à jour");
		        Job updateJob = Job.create("Recherche de mises à jour", monitor -> {
		        	try {
		            IStatus status = performUpdates(agent, monitor);
		            System.out.println("Update process completed with status: " + status);
		            if (!status.isOK() && status.getSeverity() != IStatus.CANCEL ) {
		            	 String errorDetails = getStatusDetails(status);
		            	 System.err.println("Update failed: " + errorDetails);
		            	 
		                Display.getDefault().asyncExec(() -> 
		                    MessageDialog.openError(null, "Erreur", "Échec de la mise à jour: " + errorDetails)
		                );
		            }
		        } catch (Exception e) {
	                System.err.println("Exception during update: " + e.getMessage());
	                e.printStackTrace();
	            }
		        });
		        updateJob.schedule();
		    }

		    private IStatus performUpdates(final IProvisioningAgent agent, IProgressMonitor monitor) {
		    	 System.out.println("Creating provisioning session");
		        final ProvisioningSession session = new ProvisioningSession(agent);
		        final UpdateOperation operation = new UpdateOperation(session);

		        try {
		            URI uri = new URI(repo_loc);
		            System.out.println("Setting repository: " + uri);
		            operation.getProvisioningContext().setArtifactRepositories(uri);
		            operation.getProvisioningContext().setMetadataRepositories(uri);
		            
		            System.out.println("Resolving updates...");
		            final IStatus status = operation.resolveModal(monitor);
		            logStatus("Resolution status", status);
		            
		            if (status.getCode() == UpdateOperation.STATUS_NOTHING_TO_UPDATE) {
		                Display.getDefault().asyncExec(() -> 
		                    MessageDialog.openInformation(null, "Mise à jour", "Aucune mise à jour disponible.")
		                );
		                return Status.CANCEL_STATUS;
		            }

		            if (!status.isOK()) {
		                return status; // Return the error status
		            }
		            
		            boolean userConfirmed = Display.getDefault().syncCall(() -> 
		                MessageDialog.openQuestion(
		                    null, 
		                    "Mise à jour disponible", 
		                    "Une mise à jour est disponible. Voulez-vous l'installer ?"
		                )
		            );

		            if (!userConfirmed) {
		                return Status.CANCEL_STATUS;
		            }
		            System.out.println("User confirmed update - proceeding with installation");
		         

		            ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
		            if (provisioningJob == null) {
		            	System.err.println("ProvisioningJob is null - cannot proceed with update");
		            	  Display.getDefault().asyncExec(() -> {
		            	        MessageDialog.openWarning(
		            	            Display.getDefault().getActiveShell(),
		            	            "Update Error",
		                            "Could not create installation job.\n" + 
		                            "Resolution result: " + operation.getResolutionResult()
		            	        );
		            	    });
		                  return new Status(IStatus.ERROR, "supercad.p2.update", "ProvisioningJob is null");

		            }
		            System.out.println("Configuring provisioning job");
		            configureProvisioningJob(provisioningJob);
		            provisioningJob.schedule();
		            return Status.OK_STATUS;

		        } catch (URISyntaxException e) {
		        	 System.err.println("Invalid repository URI: " + e.getMessage());
		             return new Status(IStatus.ERROR, "supercad.p2.update", "Invalid repository URI", e);
		        }
		    }

		    private void configureProvisioningJob(ProvisioningJob provisioningJob) {

		        provisioningJob.addJobChangeListener(new JobChangeAdapter() {
		            @Override
		            public void done(IJobChangeEvent event) {
		            	   System.out.println("Provisioning job completed with IStatusCodes : " + event.getResult().getCode());
		            	   System.out.println("Provisioning job completed with Message : " + event.getResult().getMessage());
		            	   System.out.println("Provisioning job completed with Plugin : " + event.getResult().getPlugin());
		            	   
		            	   if(event.getResult().getException()!=null)
		            	   System.out.println("Provisioning job completed with Plugin : " + event.getResult().getException().getMessage());
		            	   
						if (event.getResult().getSeverity() == IStatus.CANCEL) {
							System.err.println(
									"Provisioning job was cancelled. Possible cause: identical version already installed.");
						}
						if (event.getResult().isOK()) {
							System.out.println("Update installed successfully");
							System.out.println("Mise à jour terminée avec succès, redémarrage de l'application...");
							Display.getDefault().asyncExec(() -> {
								// Demander confirmation avant redémarrage
								boolean restartConfirmed = MessageDialog.openQuestion(null, "Redémarrage nécessaire",
										"La mise à jour a été installée avec succès.\n"
												+ "L'application doit redémarrer pour appliquer les changements.\n\n"
												+ "Redémarrer maintenant ?");

								if (restartConfirmed) {
									workbench.restart();
								}
							});
						} else {
							String errorDetails = getStatusDetails(event.getResult());
							System.err.println("Update installation failed: " + errorDetails);

							Display.getDefault().asyncExec(() -> MessageDialog.openError(null, "Erreur",
									"Échec de l'installation de la mise à jour:\n" + event.getResult().getMessage()));
						}
		            }
		        });
		    }
		    private void logStatus(String prefix, IStatus status) {
		        System.out.println(prefix + ": " + status);
		        if (status.isMultiStatus()) {
		            for (IStatus child : status.getChildren()) {
		                System.out.println("  - " + child);
		            }
		        }
		    }
		    
		    private String getStatusDetails(IStatus status) {
		        StringBuilder sb = new StringBuilder();
		        sb.append(status.getMessage());
		        
		        if (status.getException() != null) {
		            sb.append("\nException: ").append(status.getException().getMessage());
		        }
		        
		        if (status.isMultiStatus()) {
		            for (IStatus child : status.getChildren()) {
		                sb.append("\n  - ").append(child.getMessage());
		                if (child.getException() != null) {
		                    sb.append(" [").append(child.getException().getMessage()).append("]");
		                }
		            }
		        }
		        
		        return sb.toString();
		    }
		    
}
