package dressing.model.persistence.dpos;

import java.util.Properties;
import java.util.UUID;
import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.Vector4;
import gdxapp.object3d.ModelsLoader;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="object3d")
public class Object3D{
	
	protected ObjectType objectType;
	protected boolean staticObject;
	protected UUID uuid;
	protected UUID sceneID;
	protected Vector3 position;
	protected Vector4 dimension;
	protected float rotation;
	protected Properties properties;
	
	public Object3D() {
		super();
	}
	
	public Object3D(WorldObject actor) {
		this.objectType = actor.getType();
		this.position = actor.getRealWorldPosition();
		this.dimension = actor.getRealWorldDimension();
		this.rotation = actor.getRotation();
		this.uuid = actor.getUuid(); 
		this.sceneID = actor.getSceneId();
		this.staticObject = actor.isStaticobject();
		this.properties = actor.getProperties();
	}

	


	
	public <T extends WorldObject> T getWorldActor() {	
		
		if(position==null) {
			position=new Vector3(0, 0, 0);
		}
		if(position.x==Float.NaN) {
			position.x=0;
		}
		if(position.y==Float.NaN) {
			position.y=0;
		}
		if(position.z==Float.NaN) {
			position.z=0;
		}
		WorldObject worldObject = null;
		if(objectType.equals(ObjectType.MODELED)) {
			WorldObject modelObject =  ModelsLoader.getInstance().findObject(this.uuid);
			if(modelObject != null) {
				worldObject = modelObject.clone();
				worldObject.setRealWorldDimension(this.dimension);
				worldObject.setRealWorldPosition(this.position);
				worldObject.setRotation(this.rotation);
				worldObject.setProperties(this.properties);
				worldObject.setStaticobject(this.staticObject);
				worldObject.setUuid(this.uuid);
				worldObject.setSceneId(this.sceneID);
				Object movableObject=this.getProperties().getOrDefault("isMovable", "true");
				boolean ismovable=movableObject instanceof String ?Boolean.valueOf((String)movableObject ):(Boolean) movableObject;
				worldObject.setMoveable(ismovable);
			}
		}
		return (T) worldObject;
	}

	public UUID getUuid() {
		return uuid;
	}

	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}

	public Vector3 getPosition() {
		return position;
	}

	public void setPosition(Vector3 position) {
		this.position = position;
	}

	public Vector4 getDimension() {
		return dimension;
	}

	public void setDimension(Vector4 dimension) {
		this.dimension = dimension;
	}

	public float getRotation() {
		return rotation;
	}

	public void setRotation(float rotation) {
		this.rotation = rotation;
	}

	public ObjectType getObjectType() {
		return objectType;
	}

	public void setObjectType(ObjectType objectType) {
		this.objectType = objectType;
	}

	public Properties getProperties() {
		if(properties==null) {
			properties=new Properties();
		}
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	public boolean isStaticObject() {
		return staticObject;
	}

	public void setStaticObject(boolean staticObject) {
		this.staticObject = staticObject;
	}

	

	public WorldObject get(WorldObject worldObject) {
		worldObject.setUuid(uuid);
		worldObject.setSceneId(sceneID);
		worldObject.setStaticobject(staticObject);
		worldObject.setRealWorldPosition(position);
		worldObject.setRealWorldDimension(dimension);
		worldObject.setRotation(rotation);
		worldObject.setProperties(properties);
		worldObject.setType(objectType);
		return worldObject;
	}


	protected void  set(WorldObject  entity) {
		this.objectType = entity.getType();
		this.position = entity.getRealWorldPosition();
		this.dimension = entity.getRealWorldDimension();
		this.rotation = entity.getRotation();
		this.uuid = entity.getUuid(); 
		this.sceneID = entity.getSceneId();
		this.staticObject = entity.isStaticobject();
		this.properties = entity.getProperties();		
	}
	
	
	public <T extends Object3D> T from(WorldObject entity, T out) {
		out.set(entity);
		return out;
	}



}
