package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.Bande;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.evalutor.Equation;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PieceType;
/**
 * ce class represente le coeur de calcul pour les piece de type Bande ,
 * pour simplifier le code de calcul des composant 3D en créer un class 
 * pour les piece ou les composant compliquées dans son calcul pour rendre le code readable et maintainable 
 * @author Imed
 *
 */
public class BandeDebitageFormulas extends DebitageFormulas {

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof CaissonCuisine && child instanceof Bande)
		{	
			Piece2D piece2d  = (Piece2D)child;
			CaissonCuisine caissonCuisine = (CaissonCuisine)parent;
			PieceType piecetype = piece2d.getPiecetype();
			CuisineCaissonType cuisineCaissonType =caissonCuisine.getCaissoncuisineType();
			switch (cuisineCaissonType) {
				case Bloc_Tiroir:
				case Porte_Boteille:
				case Porte_Pain:	
				case Bas:
					switch (piecetype) {
						case BANDE_ARRIERE:
							FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						
							//Fromules de debitage
							ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				

							ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	
							ADDOrUpdateEquation("@this.p@", "@largeur.bande@", Equation.CALCULATION_AUTO,equations) ;
							if(((Caisson) caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
								ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
							}else if(((Caisson) caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
							{
								ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
							}else
								throw new DesignException("type de montage non supporter");
							
							
							ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @this.e@ ", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posz@", "@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
							
							ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						
							FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);		
							if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
								FILL_CHANT_EPAISSEUR("@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
							}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
								FILL_CHANT_EPAISSEUR("@ep.deuxmm@","0","@ep.deuxmm@","0",equations);
							}
							
							FILL_PIECE2D(piece2d, equations);
							
							break;
						
						case BANDE_AVANT:
							FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
							ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				
							//Fromules de debitage
							ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.p@", "@largeur.bande@", Equation.CALCULATION_AUTO,equations) ;
							if(((Caisson) caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
								ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
							}else if(((Caisson) caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
							{
								ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
							}else
								throw new DesignException("type de montage non supporter");
							
							
							ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @this.e@ ", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @largeur.bande@", Equation.CALCULATION_AUTO,equations) ;
							
							ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							//
							FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
							if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
								FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
							}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
								FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
							}
							//
							FILL_PIECE2D(piece2d, equations);
							
							break;			
						
						default:
							throw new DesignException(piecetype+" not found in debitage formula");
						}
						break;
						
				case Bas_four:
					switch (piecetype) {
					case BANDE_ARRIERE:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
					
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandehautbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @largeur.bandehautbasfour@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
					
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);		
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.deuxmm@","0","@ep.deuxmm@","0",equations);
						}
						
						FILL_PIECE2D(piece2d, equations);
						
						break;
						
					case BANDE_AVANT:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandehautbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @largeur.bandehautbasfour@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.e@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;			
					case BANDE_FOUR_BAS_FACE:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandebasbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
												
						ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.e@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;	
					case BANDE_FOUR_BAS_DROITE1:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandebasbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.bascaissoncuisine@ - @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - 3*@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;	
					case BANDE_FOUR_BAS_DROITE2:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandebasbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.bascaissoncuisine@ - @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - 2*@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
						
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;	
					case BANDE_FOUR_BAS_GAUCHE1:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandebasbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.bascaissoncuisine@ - @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
	
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;	
					case BANDE_FOUR_BAS_GAUCHE2:
						FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						//Fromules de debitage
						ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

						ADDOrUpdateEquation("@this.h@", "@largeur.bandebasbasfour@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.bascaissoncuisine@ -@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
						ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "2*@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
						
						
						
						ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
	
						ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						//
						FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
						if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
						}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
							FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
						}
						//
						FILL_PIECE2D(piece2d, equations);
						
						break;	
					default:
						throw new DesignException(piecetype+" not found in debitage formula");
					}
					break;
				case Bas_sousevier:					
				

					switch (piecetype) {
						case BANDE_ARRIERE:
							FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
						
							//Fromules de debitage
							ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

							ADDOrUpdateEquation("@this.h@", "@largeur.bande@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
							
							ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
							
							
							ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @largeur.bande@ ", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
							
							ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
						
							FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);		
							if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
								FILL_CHANT_EPAISSEUR("@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
							}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
								FILL_CHANT_EPAISSEUR("@ep.deuxmm@","0","@ep.deuxmm@","0",equations);
							}
							
							FILL_PIECE2D(piece2d, equations);
							
							break;
							
						case BANDE_AVANT:
							FILL_PIECE2D_FROM_PARENT(caissonCuisine, equations);
							//Fromules de debitage
							ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	

							ADDOrUpdateEquation("@this.h@", "@largeur.bande@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
						
							ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
							
							
							
							ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @largeur.bande@ ", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.e@", Equation.CALCULATION_AUTO,equations) ;
							
							ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
							//
							FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
							if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
								FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
							}else if(caissonCuisine instanceof Caisson && ((Caisson)caissonCuisine).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
								FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
							}
							//
							FILL_PIECE2D(piece2d, equations);
							
							break;			
							
						default:
							throw new DesignException(piecetype+" not found in debitage formula");
						}
						break;
				default:
					throw new DesignException(piecetype+" not found in debitage formula");
							
			}
			
			
				
			
		}else
		{
			throw new DesignException("Unkown Debitage Formula");
		}
	}
}
