package dressing.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ReportingPreferences extends Properties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static ReportingPreferences instance;

	/**
	 * Returns an instance of ArrayContentProvider. Since instances of this class do
	 * not maintain any state, they can be shared between multiple clients.
	 *
	 * @return an instance of ArrayContentProvider
	 *
	 * @since 3.5
	 */
	public static ReportingPreferences getInstance() {
		synchronized (ReportingPreferences.class) {
			if (instance == null) {
				instance = new ReportingPreferences();
			}
			return instance;
		}
	}

	public ReportingPreferences() {
		super();
		init();
	}

	private void init() {
		InputStream in = null;
		try {
			File file=new File(WorkspaceConfiguration.getReportingPrefs());
			if(!file.exists()) {
				file.createNewFile();
			}
			in = new FileInputStream(file);
			load(in);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	@Override
	public String getProperty(String key, String defaultValue) {
		if (getProperty(key) == null) {
			put(key, defaultValue);
			save();
			return defaultValue;
		}
		return super.getProperty(key, defaultValue);
	}
	public boolean getProperty(String key, boolean defaultValue) {
		return Boolean.valueOf(getProperty(key, String.valueOf(defaultValue)));
	}
	public void put(String key,boolean value) {
		put(key,String.valueOf(value));
	}
	public void save() {

		try {
			File file=new File(WorkspaceConfiguration.getReportingPrefs());
			if(!file.exists()) {
				file.createNewFile();
			}
			this.store(new FileOutputStream(file), null);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
