package org.frs.svg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import org.frs.svg.SvgDrawer.RENDERING_MODE;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxNativesLoader;



public class Application {


	
	static  {
		GdxNativesLoader.load();
	}
	
	
	public static void testGCoords() {
		Vector3 v0 = new Vector3(90,20,0),  v1 = new Vector3(30,140,0), v2 = new Vector3(205,180,0);
		
		Vector3 m = v0.cpy().scl(0.8f).add(v1.cpy().scl(0.1f)).add(v2.cpy().scl(0.1f));
		Vector3 m1 = v1.cpy().scl(0.8f).add(v2.cpy().scl(0.1f)).add(v0.cpy().scl(0.1f));
		Vector3 m2 = v2.cpy().scl(0.8f).add(v1.cpy().scl(0.1f)).add(v0.cpy().scl(0.1f));

		System.out.println(SvgPrinter.writeTriangle(v0, v1, v2, new Vector3()));
		System.out.println(m + "\n" + m1 + "\n" + m2);
		
	}

	
	public static void main(String... args) {		
		ProjectionCamera camera = new ProjectionCamera(1.0f, 160, 480.0f/720.0f, 1024);
		camera.setPosition(new Vector3(4,3,6f));
		camera.lookAt(new Vector3());
		
		Box outer = new Box(new Vector3(), new Vector3(2, 1, 2));
		outer.setColor(new Vector3(1,1,0));
		outer.defineMesh(1);
		Box inner = new Box(new Vector3(), new Vector3(1, 2, 1));
		inner.setColor(new Vector3(1,0,0));
		inner.defineMesh(1);
		//inner.setTransform(new Matrix4(new Vector3(0,0,0), new Quaternion(Vector3.Y, 45), new Vector3(1,1,1)));

		
		SvgDrawer drawer = new SvgDrawer();
		SVGRenderingTask task = new SVGRenderingTask(RENDERING_MODE.FILLED, outer, inner);
		drawer.addRenderable(task);

		drawer.begin(camera);
		drawer.render(camera);
		String img = drawer.end();
		File file = new File("C:\\Users\\nadhe\\OneDrive\\Bureau\\ayman\\report.txt");
		try {
			FileOutputStream fos = new FileOutputStream(file);
			fos.write(img.getBytes());
			fos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally {
			System.out.println("finsihed!");
		}
	}
}
