/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;

public class TableRenderingContentDescriptor {
    private AbstractBaseTableRendering fRendering;
    private int fPreBuffer;
    private int fPostBuffer;
    private BigInteger fLoadAddress;
    private int fNumLines;
    private BigInteger fMemoryBlockBaseAddress;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private int fAddressSize = -1;
    private int fAddressableSize = -1;
    private boolean fAlignAddress = true;
    private boolean fIsDynamicLoad;

    public TableRenderingContentDescriptor(AbstractBaseTableRendering rendering) {
        this.fRendering = rendering;
    }

    public int getPostBuffer() {
        return this.fPostBuffer;
    }

    public int getPreBuffer() {
        return this.fPreBuffer;
    }

    public BigInteger getLoadAddress() {
        return this.fLoadAddress;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fRendering.getMemoryBlock();
    }

    public void setPostBuffer(int postBuffer) {
        this.fPostBuffer = postBuffer;
    }

    public void setPreBuffer(int preBuffer) {
        this.fPreBuffer = preBuffer;
    }

    public void setLoadAddress(BigInteger address) {
        this.fLoadAddress = address;
    }

    public BigInteger getContentBaseAddress() {
        if (this.fMemoryBlockBaseAddress == null) {
            try {
                this.updateContentBaseAddress();
            }
            catch (DebugException debugException) {
                this.fMemoryBlockBaseAddress = BigInteger.ZERO;
            }
        }
        return this.fMemoryBlockBaseAddress;
    }

    public void updateContentBaseAddress() throws DebugException {
        IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
        this.fMemoryBlockBaseAddress = memoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memoryBlock).getBigBaseAddress() : BigInteger.valueOf(memoryBlock.getStartAddress());
    }

    public BigInteger getStartAddress() {
        if (this.fStartAddress == null) {
            try {
                BigInteger startAddress;
                IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
                if (memoryBlock instanceof IMemoryBlockExtension && (startAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockStartAddress()) != null) {
                    this.fStartAddress = startAddress;
                }
            }
            catch (DebugException debugException) {
                this.fStartAddress = BigInteger.ZERO;
            }
            if (this.fStartAddress == null) {
                this.fStartAddress = BigInteger.ZERO;
            }
        }
        return this.fStartAddress;
    }

    public BigInteger getEndAddress() {
        if (this.fEndAddress == null) {
            IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
            if (memoryBlock instanceof IMemoryBlockExtension) {
                BigInteger endAddress;
                try {
                    endAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockEndAddress();
                    if (endAddress != null) {
                        this.fEndAddress = endAddress;
                    }
                }
                catch (DebugException debugException) {
                    this.fEndAddress = null;
                }
                if (this.fEndAddress == null) {
                    int addressSize;
                    try {
                        addressSize = ((IMemoryBlockExtension)memoryBlock).getAddressSize();
                    }
                    catch (DebugException debugException) {
                        addressSize = 4;
                    }
                    endAddress = BigInteger.valueOf(2L);
                    endAddress = endAddress.pow(addressSize * 8);
                    this.fEndAddress = endAddress = endAddress.subtract(BigInteger.valueOf(1L));
                }
            }
            if (this.fEndAddress == null) {
                this.fEndAddress = BigInteger.valueOf(Integer.MAX_VALUE);
            }
        }
        return this.fEndAddress;
    }

    public int getNumLines() {
        return this.fNumLines;
    }

    public void setNumLines(int numLines) {
        this.fNumLines = numLines;
    }

    public AbstractBaseTableRendering getRendering() {
        return this.fRendering;
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    public void setAddressableSize(int addressableSize) {
        this.fAddressableSize = addressableSize;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public void setAddressSize(int addressSize) {
        this.fAddressSize = addressSize;
    }

    public void setDynamicLoad(boolean dynamic) {
        this.fIsDynamicLoad = dynamic;
    }

    public boolean isDynamicLoad() {
        return this.fIsDynamicLoad;
    }

    public boolean isMemoryBlockBaseAddressInitialized() {
        return this.fMemoryBlockBaseAddress != null;
    }

    public boolean isAlignAddressToBoundary() {
        return this.fAlignAddress;
    }

    public void setAlignAddressToBoundary(boolean align) {
        this.fAlignAddress = align;
    }
}

