package dressing.reporting.data.handle;

import dressing.config.ReportingPreferences;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.Space3DFree;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.util.StaticUiObjects;

public class DesignCoupe {
	private String name;
	private String code;
	private String number;

	private AccessoireGroupCoupe accessoires;
	private AccessoireGroupCoupe Quincailleries;
	private double length;
	private double heigh;
	private double depth;
	private DesignObject3D design;
	private String BoxMaterial;
	private String facadeMaterial;
	private String dosMaterial;
	private double designCost=0;
	private String sdesignCost;
	private double totaldesignCost=0;
	private String stotalDesignCost;
	private double totalAccessoiresCost=0;
	private String stotalAccessoiresCost;
	private double totalQuincailleriesCost=0;
	private String stotalQuincailleriesCost;
	public DesignCoupe(DesignObject3D el, String name, String number, double length, double heigh, double depth) {
		super();
		this.name = name;
		this.number = number;
		this.length = length;
		this.heigh = heigh;
		this.depth = depth;
		this.design=el;
		init();
	}
	private void init() {
			this.name=design.getName();
			this.code=design.getMechanicDesignDefinition().getCode();
			this.BoxMaterial=design.getMechanicDesignDefinition().getPrincipalmaterial().getName();
			this.facadeMaterial=design.getMechanicDesignDefinition().getFacadeMaterial().getName();
			this.dosMaterial=design.getMechanicDesignDefinition().getSecondmaterial().getName();
		
		try {
			MechanicDesignCreator.getInstance().updateAccessoiresAndQuincailleries(design, design.getMechanicDesignDefinition(), null);
		} catch (DesignException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (GeometricEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		accessoires=new AccessoireGroupCoupe((Space3DFree) design,true);
		Quincailleries=new AccessoireGroupCoupe((Space3DFree) design,false);
		
		designCost=this.design.getMechanicDesignDefinition().getPrice();
		sdesignCost=StaticUiObjects.decimalMoneyFormat.format(designCost);
		totaldesignCost=designCost;
		totalAccessoiresCost=getAccessoires().getTotalPrice();
		stotalAccessoiresCost=StaticUiObjects.decimalMoneyFormat.format(totalAccessoiresCost);
		if(isshowAccessoire()>0) {
			totaldesignCost+=totalAccessoiresCost;
		}
		totalQuincailleriesCost=getQuincailleries().getTotalPrice();
		stotalQuincailleriesCost=StaticUiObjects.decimalMoneyFormat.format(totalQuincailleriesCost);
		if(isShowQuicaillerie()>0) {
			totaldesignCost+=totalQuincailleriesCost;
		}
		stotalDesignCost = StaticUiObjects.decimalMoneyFormat.format(totaldesignCost);
	}
	
	public DesignCoupe() {
		super();
		// TODO Auto-generated constructor stub
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public String getCode() {
		return code;
	}
	public String getNumber() {
		return number;
	}
	public void setNumber(String number) {
		this.number = number;
	}
	
	public AccessoireGroupCoupe getAccessoires() {
		return accessoires;
	}
	public AccessoireGroupCoupe getQuincailleries() {
		return Quincailleries;
	}
	public double getLength() {
		return length;
	}
	public void setLength(double length) {
		this.length = length;
	}
	public double getHeigh() {
		return heigh;
	}
	public void setHeigh(double heigh) {
		this.heigh = heigh;
	}
	public double getDepth() {
		return depth;
	}
	public void setDepth(double depth) {
		this.depth = depth;
	}

	public String getBoxMaterial() {
		return BoxMaterial;
	}
	public void setBoxMaterial(String boxMaterial) {
		BoxMaterial = boxMaterial;
	}

	public String getSdesignCost() {
		return sdesignCost;
	}
	public String getFacadeMaterial() {
		return facadeMaterial;
	}
	public void setFacadeMaterial(String facadeMaterial) {
		this.facadeMaterial = facadeMaterial;
	}
	public String getDosMaterial() {
		return dosMaterial;
	}
	public void setDosMaterial(String dosMaterial) {
		this.dosMaterial = dosMaterial;
	}
	
	public double isshowAccessoire() {
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		double returnVal= isShowAccessoire&&accessoires.getTotalNumber()>0?1.0:-1.0;
		
		return returnVal;
	}
	public double isShowQuicaillerie() {
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		double returnVal= isShowQuicaillerie&&Quincailleries.getTotalNumber()>0?1.0:-1.0;
		
		return returnVal;
	}
	public double isshowAccessoireAndQuicaillerie() {
		return isshowAccessoire()+isShowQuicaillerie()+1;
	}

	public double getDesignCost() {
		return designCost;
	}
	public double getTotaldesignCost() {
		return totaldesignCost;
	}
	public double totaltableRowCount() {
		double nbColumn=3;
		if(isshowAccessoire()>0) {
			nbColumn++;
		}
		if(isShowQuicaillerie()>0) {
			nbColumn++;
		}
		
		
		return nbColumn;
	}
	
	public DesignObject3D getDesign() {
		return design;
	}
	public String getStotalDesignCost() {
		return stotalDesignCost;
	}
	
	public double getTotalAccessoiresCost() {
		return totalAccessoiresCost;
	}
	public String getStotalAccessoiresCost() {
		return stotalAccessoiresCost;
	}
	public double getTotalQuincailleriesCost() {
		return totalQuincailleriesCost;
	}
	public String getStotalQuincailleriesCost() {
		return stotalQuincailleriesCost;
	}
	public double ishowAccessoireAndQuicaillriesamePage() {
		
		
		return -1;
	}
	
}