package dressing.model;


import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import dressing.model.evalutor.GeometricEngineException;
import tech.frsdev.solids.Solide3D;



public class Project3D  extends DesignObject3D{
	private String directory="";
	private String fullpath="";
	private String extension=".xml";
	public Project3D() {
		// TODO Auto-generated constructor stub
		if(propertyChangeSupport!=null)
		{
			propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if(evt.getPropertyName().equals("name") || evt.getPropertyName().equals("directory"))
					{
						setFullpath(getDirectory()+"\\"+getName()+getExtension());
					}
				}
			});
		}
		 fillParams();
	}
    public void initafterread() {
    	super.initafterread();
		if(propertyChangeSupport!=null)
		{
			propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if(evt.getPropertyName().equals("name") || evt.getPropertyName().equals("directory"))
					{
						setFullpath(getDirectory()+"\\"+getName()+getExtension());
					}
				}
			});
		}
    }
	public void setChilds(List<DesignObject3D> childs) {
		this.childs = childs;
	}
	public List<DesignObject3D> getChilds() {
		return childs;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Dressing||child instanceof Cuisine)
			return true;
		return false;
	}
public void setDirectory(String directory) {

	String oldValue = this.directory;
	this.directory = directory;
	firePropertyChange("directory", oldValue, directory);
}
public String getDirectory() {
	return directory;
}
public void setFullpath(String fullpath) {

	String oldValue = this.fullpath;
	this.fullpath = fullpath;
	firePropertyChange("fullpath", oldValue, fullpath);
}
public String getFullpath() {
	return fullpath;
}
public String getExtension() {
	return extension;
}

public void setExtension(String extension) {
	this.extension = extension;
}
@Override
public int hashCode() {
	// TODO Auto-generated method stub
	return super.hashCode();
}
@Override
public boolean equals(Object obj) {
	// TODO Auto-generated method stub
		if(obj instanceof Project3D)
		{
			if (this.getFullpath() != null && obj != null && ((Project3D) obj).getFullpath() != null) {
				if (this.getFullpath().equals(((Project3D) obj).getFullpath())) {
					return true;
				} else {
					return false;
				}
			}
			return false;
		}
		return super.equals(obj);
}
@Override
public double getXSize() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public double getYSize() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public double getZSize() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public double getXPosition() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public double getYPosition() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public double getZPosition() {
	// TODO Auto-generated method stub
	return 0;
}
@Override
public List<Solide3D> getChildren() {
	// TODO Auto-generated method stub
	return null;
}
@Override
public BufferedImage getImage() {
	// TODO Auto-generated method stub
	return null;
}
@Override
public boolean isdrawable() {
	// TODO Auto-generated method stub
	return false;
}
@Override
public Boolean isSelected() {
	// TODO Auto-generated method stub
	return null;
}
@Override
public void fillParams() {
	// TODO Auto-generated method stub
	if(ModelProvider.getListParam()!=null && ModelProvider.getListParam().size()!=0) {
		this.params.clear();
		for(Parameters param : ModelProvider.getListParam())
		{
			this.params.add(param.clone());
		}
	}
}


@Override
public DesignObject3D clone() {
	Project3D space=new Project3D();
	try {
		space=(Project3D) this.copy(space);
	} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	return space;
}
@Override
public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
	Project3D project=(Project3D)object;
	project.setDirectory(getDirectory());
	project.setFullpath(getFullpath());
	project.setName(getName());
	project.setExtension(getExtension());
	
	 for(DesignObject3D design:getChilds() ) {
		 project.addElement(design.clone());			
	 }
	return project;
}
}
