package dressing.mathutils.simulatedannealing;

import com.badlogic.gdx.math.Vector3;

public class SATest {
	
	public static void main(String[] args) {
		
		Vector3 point1 = new Vector3(0,10,0);
		Vector3 point2 = new Vector3(2,9.8f,0);
		Vector3 point3 = new Vector3(3,9.5f,0);
		Vector3 point4 = new Vector3(7,7.14f,0);
		Vector3 point5 = new Vector3(5,8.6f,0);
		Vector3 point6 = new Vector3(10,0,0);
		Vector3 point7 = new Vector3(0,-10,0);


		Problem problem = new Problem();
		problem.points.add(point5);
		problem.points.add(point4);
		problem.points.add(point3);
		problem.points.add(point2);
		problem.points.add(point1);
		problem.points.add(point6);
		problem.points.add(point7);
		
		Config config = new Config();
		config.setInitialTemprature(1000000);
		config.setCoolingRate(0.01f);
		Solver solver = new Solver(config);
		double bestSolution = -1;
		double worstSolution = -1;
		int i = 200;
		while(i > 0) {
			Solution solution = solver.solve(problem);
			double score=solution.calculateFitness();
			if(i == 200) {
				bestSolution = score;
				worstSolution = score;
			}
			if(score < bestSolution)
				bestSolution = score;
			if(score > worstSolution)
				worstSolution = score;
			i--;
		}
		System.out.println("best score: " + bestSolution + " worst score: " + worstSolution);
	}
}
