package org.frs.structures.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import javax.swing.plaf.basic.BasicInternalFrameTitlePane.MaximizeAction;

//this class represents a column majored grid whose columns and rows size re not necesserily equal
public class Grid implements Iterable<Cell> {
	
	private float[] cellPadding;
	private float[] columnsWidth;
	private float[] rowsHeight;
	//column major grid
	private Cell[][] cells;
	
	private float width;
	private float height;
	
	public Grid(float[] columnsWidth, float[] rowsHeight, float...padding) {
		this.columnsWidth = columnsWidth;
		this.rowsHeight = rowsHeight;
		this.cellPadding = padding;
		width = 0;
		for(int i = 0; i < columnsWidth.length; i++) {
			width += columnsWidth[i];
		}
		for(int i = 0; i < rowsHeight.length; i++) {
			height += rowsHeight[i];
		}
	}
	
	public void populate() {
		int columns = this.columnsWidth.length;
		int rows = this.rowsHeight.length;
		cells = new Cell[columns][rows];
		int x = 0;
		for(int i = 0; i < columns;i++) {
			int y = 0;
			for(int j = 0; j < rows; j++) {
				cells[i][j] = new Cell(x, y, columnsWidth[i], rowsHeight[j], cellPadding);
				y += rowsHeight[j];
			}
			x += columnsWidth[i];
			
		}
	}
	
	public Cell[] getColumn(int index) {
		return cells[index];
	}
	
	public Cell[] getRow(int index){
		Cell[] row = new Cell[columnsWidth.length];
		int current = 0;
		for(int i = 0; i < columnsWidth.length; i++) {
			row[current++] = getColumn(i)[index]; 
		}
		return row;
	}
	
	public Cell get(int i, int j) {
		return cells[i][j];
	}
	
	public Cell get(Object value) {
		for(Cell cell: this) {
			if(cell.get() != null && cell.get().equals(value))
				return cell;
		}
		return null;
	}

	@Override
	public Iterator<Cell> iterator() {
		return new GridIterator(this);
	}

	public float[] getCellPadding() {
		return cellPadding;
	}

	public void setCellPadding(float[] cellPadding) {
		this.cellPadding = cellPadding;
	}

	public float[] getColumnsWidth() {
		return columnsWidth;
	}

	public void setColumnsWidth(float[] columnsWidth) {
		this.columnsWidth = columnsWidth;
	}

	public float[] getRowsHeight() {
		return rowsHeight;
	}

	public void setRowsHeight(float[] rowsHeight) {
		this.rowsHeight = rowsHeight;
	}

	public Cell[][] getCells() {
		return cells;
	}

	public void setCells(Cell[][] cells) {
		this.cells = cells;
	}

	public float getWidth() {
		return width;
	}

	public void setWidth(float width) {
		this.width = width;
	}

	public float getHeight() {
		return height;
	}
	public void setHeight(float height) {
		this.height = height;
	}
	
}
