package gdxapp.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;

import dressing.config.WorkspaceConfiguration;
import gdxapp.assets.AssetsTextures;

public class ZoomComponent extends Table{
	
	Slider slider;
	Label valueLabel;
	float value;
	
	public ZoomComponent(){
		super();
		this.setFillParent(true);
		slider = new Slider(.1f,10,.1f,true,AssetsTextures.getInstance().getSkin(),"default-vertical");
		Label label = new Label("Zoom: ",AssetsTextures.getInstance().getSkin(),"font", "black");
		value = slider.getValue();
		valueLabel = new Label("" + value, AssetsTextures.getInstance().getSkin(),"font", "black");
		add(label);
		add(valueLabel);
		add(slider);
	}


	public Slider getSlider() {
		return slider;
	}


	public void setSlider(Slider slider) {
		this.slider = slider;
	}


	public Label getValueLabel() {
		return valueLabel;
	}


	public void setValueLabel(Label valueLabel) {
		this.valueLabel = valueLabel;
	}
	
	
	
	
	

}
