package dressing.ui.project;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.awt.event.*;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;

import dressing.model.ModelProvider;
import dressing.model.persistence.MapEntry;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Wall;
import gdxapp.scenes.ScenePreferences;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.Wall2D;
import gdxapp.shaders.PbrMaterial;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.Gdx;

public class WallConfigformComposite extends Composite {

	private String wallStyle;
	private Wall wall;
	private HashMap<String, String> styles;
	private Button btnPreview;
	private TableComboViewer tcvTexture;
	private TableComboViewer tcvStyles;
	private Spinner spnHeight;
	Spinner spnThickness;
	
	float thickness;
	float height;
	private String style;
	private SceneTexture albedoMap;
	

	public WallConfigformComposite(Composite parent, int style) {
		super(parent, style);
		
		styles = AssetsTextures.getInstance().getWallStyles();
		setLayout(new GridLayout(1, false));
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setBounds(0, 0, 64, 64);

		CBanner banner = new CBanner(composite, 0);
		banner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setBounds(0, 0, 580, 307);

		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_1);
		composite_1.setLayout(new GridLayout(1, false));

		btnPreview = new Button(composite_1, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_2);
		GridLayout gl_composite_2 = new GridLayout(1, false);
		gl_composite_2.marginBottom = 50;
		gl_composite_2.marginTop = 50;
		composite_2.setLayout(gl_composite_2);

		Composite composite_3 = new Composite(composite_2, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_3.setBounds(0, 0, 261, 57);
		composite_3.setLayout(new GridLayout(2, false));

		Label lblType = new Label(composite_3, SWT.NONE);
		lblType.setText("Style");
		lblType.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));

		tcvStyles = new TableComboViewer(composite_3, SWT.NONE);
		tcvStyles.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				setWallStyle((String) tcvStyles.getStructuredSelection().getFirstElement());
			}
		});
		TableCombo tilesTC = tcvStyles.getTableCombo();
		tilesTC.setEditable(false);
		tilesTC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvStyles.setContentProvider(ArrayContentProvider.getInstance());
		tcvStyles.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				return element.toString();
			}
		});
		tcvStyles.setInput(styles.keySet());
		tcvStyles.addSelectionChangedListener(new ISelectionChangedListener() {			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				styleChanged();
			}
		});

		Label lblTexture = new Label(composite_3, SWT.NONE);
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		lblTexture.setText("Texture");

		tcvTexture = new TableComboViewer(composite_3, SWT.NONE);
		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				textureChanged();
			}
		});
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(new SingleImageItemLabelProvider(composite_3));

		Label lblHauteur = new Label(composite_3, SWT.NONE);
		lblHauteur.setText("Hauteur");

		spnHeight = new Spinner(composite_3, SWT.BORDER);
		spnHeight.setMaximum(10000);
		spnHeight.setMinimum(1);
		spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnHeight.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				height =  spnHeight.getSelection() / 1000.0f;
			}
		});

		

		Label lblEpaisseur = new Label(composite_3, SWT.NONE);
		lblEpaisseur.setText("Epaisseur");

		spnThickness = new Spinner(composite_3, SWT.BORDER);
		spnThickness.setMaximum(1000);
		spnThickness.setMinimum(100);
		spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnThickness.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				thickness =  spnThickness.getSelection() / 1000.0f;
			}
		});		
		tcvTexture.setInput(ModelProvider.getTextures(CATEGORY.WALL));
		
		

	}

	private void textureChanged() {
		albedoMap = (SceneTexture) tcvTexture.getStructuredSelection().getFirstElement();
		btnPreview.setImage(albedoMap.getPreview());
	}
	
	private void styleChanged() {
		style = (String) tcvStyles.getStructuredSelection().getFirstElement();
	}
	
	public void bind() {
		if(wall == null)
			return;
		height = Math.round(wall.getHeight() > 0 ? wall.getHeight() * 1000 : 2500);
		spnHeight.setSelection(Math.round(height));
		thickness = Math.round(wall.getThickness() > 0 ? wall.getThickness() * 1000 : 100);
		spnThickness.setSelection(Math.round(thickness));
		String normalMapPth = wall.getMaterial().getNormalMapPath();
		if(normalMapPth != null) {
			String styleX = null;
			for(Map.Entry<String, String> entry: this.styles.entrySet()) {
				if(entry.getValue().contentEquals(normalMapPth)) {
					styleX = entry.getKey();
					break;
				}
			}
			if(styleX != null) {
				tcvStyles.setSelection(new StructuredSelection(styleX));
			}
		}
		if (wall.getMaterial().getAlbedoMapPath() != null) {
			tcvTexture.setSelection(
					new StructuredSelection(ModelProvider.getTexture(wall.getMaterial().getAlbedoMapPath())));
		}
	}
	
	public void updateWall() {
		this.wall.setHeight(height);
		this.wall.setThickness(thickness);
		this.wall.getMaterial().setNormalMapPath(this.styles.get(style));
		this.wall.getMaterial().setAlbedoMapPath(albedoMap.getPath());
		Gdx.app.postRunnable(() -> {
			this.wall.buildFragments();
			Wall2D wall2D =(Wall2D) RoomController.getInstance().getObject2D(wall);
			if(wall2D != null)
				wall2D.geometryChanged();
		});
	}
	

	public Wall getWall() {
		return wall;
	}

	public void setWall(Wall wall) {
		this.wall = wall;
		bind();
	}


	public String getWallStyle() {
		return wallStyle;
	}

	public void setWallStyle(String wallStyle) {
		this.wallStyle = wallStyle;
		styleChanged();
	}

	public int getHeight() {
		return spnHeight.getSelection();
	}

	public int getThickness() {
		return spnThickness.getSelection();
	}

	public SceneTexture getAlbedoMap() {
		return albedoMap;
	}

	public void setAlbedoMap(SceneTexture albedoMap) {
		this.albedoMap = albedoMap;
	}
	
}
