package dressing.ui.project;



import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.ui.engine3d.sceneconfig.HandlerConfigComposite;
import gdxapp.object3d.DoorHandle;
import gdxapp.scenes.ScenePreferences;



public class HandleConfigWizardPage extends WizardPage  implements PropertyChangeListener{
	
	ScenePreferences preferences;
	HandlerConfigComposite container;

	public HandleConfigWizardPage(String pageName, ScenePreferences preferences) {
		super(pageName);
		this.preferences = preferences;
		setTitle("Configuration des poignées ");
		setDescription("");
		this.preferences.addPropertyChangeListener(this);
	}

	@Override
	public void createControl(Composite parent) {
		container = new HandlerConfigComposite(parent, SWT.BORDER);
		if(preferences.getDoorHandle() == null)
			preferences.setDoorHandle(new DoorHandle());
		container.bind(preferences.getDoorHandle());
		setControl(container);
		getWizard().getContainer().updateButtons();
	}
	
	
	
	
	@Override
	public IWizardPage getNextPage() {
		container.updateDoorHandle();
		return super.getNextPage();
	}

	@Override
	public boolean isPageComplete() {
		return preferences.getDoorHandle() != null;
	}
	public void clearlistners() {
		preferences.removePropertyChangeListener(this);

	}

	public ScenePreferences getPreferences() {
		return preferences;
	}

	public void setPreferences(ScenePreferences preferences) {
		this.preferences = preferences;
	}

	@Override
	public void propertyChange(PropertyChangeEvent arg0) {
		if(isCurrentPage())
		{
			if (HandleConfigWizardPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}
	

}
